%define _name appstream-glib
%define ver_major 0.7
%define api_ver 1.0
%define asb_ver 5

%if "%(rpmvercmp '%{get_version librpm-devel}' '4.13')" >= "0"
%def_enable rpm
%endif

%def_enable stemmer
%def_enable installed_tests
%def_enable gtk_doc

Name: lib%_name
Version: %ver_major.15
Release: alt1

Summary: Library for AppStream metadata
Group: System/Libraries
License: LGPLv2+
Url: http://www.freedesktop.org/wiki/Distributions/AppStream/

Source: http://people.freedesktop.org/~hughsient/%_name/releases/%_name-%version.tar.xz

%define glib_ver 2.46
%define soup_ver 2.52
%define json_glib_ver 1.1.1

Obsoletes: appdata-tools < 0.1.9
Provides: appdata-tools = %version-%release
Provides: %_bindir/appstream-util
Provides: %_bindir/appstream-builder

Obsoletes: libappstream-builder < 0.9.15
Conflicts: libappstream-builder < 0.9.15

BuildRequires(pre): meson
BuildRequires: glib2-devel >= %glib_ver libgtk+3-devel
BuildRequires: libarchive-devel libsoup-devel >= %soup_ver libgdk-pixbuf-devel
BuildRequires: libpango-devel libsqlite3-devel
BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel
BuildRequires: gtk-doc docbook-utils docbook-dtds
BuildRequires: libyaml-devel gcab libgcab-devel gperf libuuid-devel
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: librpm-devel
%{?_enable_stemmer:BuildRequires: libstemmer-devel}

%description
This library provides GObjects and helper methods to make it easy to read and
write AppStream metadata. It also provides a simple DOM implementation that
makes it easy to edit nodes and convert to and from the standardized XML
representation.

%package devel
Summary: GLib Libraries and headers for %name
Group: Development/C
Requires: %name = %version-%release
Obsoletes: libappstream-builder-devel < 0.9.15
Conflicts: libappstream-builder-devel < 0.9.15

%description devel
GLib headers and libraries for appstream-glib.

%package gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: %name = %version-%release
Obsoletes: libappstream-builder-gir < 0.9.15
Conflicts: libappstream-builder-gir < 0.9.15

%description gir
GObject introspection data for the AppStream metadata library.

%package gir-devel
Summary: GObject introspection devel data for the %_name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release
Obsoletes: libappstream-builder-gir-devel < 0.9.15
Conflicts: libappstream-builder-gir-devel < 0.9.15

%description gir-devel
GObject introspection devel data for the AppStream metadata library.

%package devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for the AppStream
metadata library.

%package tests
Summary: Tests for the %_name package
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %_name library.


%prep
%setup -n %_name-%version

%build
%meson \
       %{?_enable_rpm:-Drpm=true} \
       %{?_enable_stemmer:-Dstemmer=true} \
       %{?_enable_gtk_doc:-Dgtk-doc=true}
%meson_build

%install
%meson_install

%find_lang %_name

%files -f %_name.lang
%_bindir/appstream-util
%_bindir/appstream-compose
%_bindir/appstream-builder
%_libdir/%name.so.*
%dir %_libdir/asb-plugins-%asb_ver
%_libdir/asb-plugins-%asb_ver/*.so
%_man1dir/appstream-util.1.*
%_man1dir/appstream-compose.1.*
%_man1dir/appstream-builder.1.*
%_datadir/bash-completion/completions/appstream-util
%_datadir/bash-completion/completions/appstream-builder
%doc README.md AUTHORS NEWS

%files devel
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%_name.pc
%_datadir/aclocal/appstream-xml.m4
%_datadir/aclocal/appdata-xml.m4
%_datadir/gettext/its/appdata.its
%_datadir/gettext/its/appdata.loc

%files gir
%_typelibdir/AppStreamGlib-%api_ver.typelib

%files gir-devel
%_girdir/AppStreamGlib-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/%_name/

%if_enabled installed_tests
%files tests
%_datadir/installed-tests/%_name/
%endif


%changelog
