%def_with bootstrap

Name: libcxxabi
Version: 7.0.0
Release: alt1

Summary: Low level support for a standard C++ library

License: MIT or NCSA
Group: System/Libraries
Url: http://libcxxabi.llvm.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://llvm.org/releases/%version/libcxxabi-%version.src.tar.xz
Source: %name-%version.tar

BuildRequires: clang llvm-devel cmake llvm-devel-static
BuildRequires: libcxx-devel >= %version

%if_with bootstrap
# make cmake compiler test happy
BuildRequires: libstdc++-devel
%endif

%description
libcxxabi provides low level support for a standard C++ library.

%package devel
Summary: Headers and libraries for libcxxabi devel
Requires: %name = %EVR
Group: System/Libraries

%description devel
%summary.

%package static
Summary: Static libraries for libcxxabi
Group: System/Libraries
Requires: %name-devel = %EVR

%description static
%summary.

%prep
%setup

# TODO: macro
%__subst 's|${LLVM_BINARY_DIR}/share/llvm/cmake|%_datadir/cmake/Modules/llvm|g' CMakeLists.txt

%build
%ifarch armv7hl
# disable ARM exception handling
%__subst 's|LIBCXXABI_ARM_EHABI 1|LIBCXXABI_ARM_EHABI 0|g' include/__cxxabi_config.h
%endif

# Clang doesn't support these options
%remove_optflags -frecord-gcc-switches

%if_with bootstrap
export LDFLAGS="-Wl,--build-id"
%else
export LDFLAGS="-Wl,--build-id -stdlib=libc++"
%endif

%cmake \
	-DCMAKE_C_COMPILER=%_bindir/clang \
	-DCMAKE_CXX_COMPILER=%_bindir/clang++ \
	-DLLVM_CONFIG=%_bindir/llvm-config \
	-DCMAKE_CXX_FLAGS="-std=c++11" \
	-DLIBCXXABI_LIBCXX_INCLUDES=%_includedir/c++/v1/ \
%if %{_lib} == "lib64"
	-DLIBCXXABI_LIBDIR_SUFFIX:STRING=64 \
%endif
	-DCMAKE_BUILD_TYPE=RelWithDebInfo

%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_includedir/
cp -a include/* %buildroot%_includedir

%files
%doc LICENSE.TXT
%doc CREDITS.TXT
%_libdir/libc++abi.so.*

%files devel
%_includedir/*.h
%_libdir/libc++abi.so

%files static
%_libdir/libc++abi.a

%changelog
