%def_disable snapshot

%define api_ver 3.0

%def_with bdb
%def_enable ical_glib
%def_enable introspection
%def_enable vala
%def_enable check
%def_enable docs
%def_with cxx
%def_with system_tzdata

Name: libical
Version: 3.0.6
Release: alt1

Summary: An implementation of basic iCAL protocols
Group: System/Libraries
License: LGPL2.1+/MPL-1.0
Url: https://github.com/%name

%if_disabled snapshot
Source: %url/%name/releases/download/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
Patch: %name-1.0.1-alt-libdir.patch

%define tzdata_ver 2019c
%{?_with_system_tzdata:Requires: tzdata >= %tzdata_ver}

BuildRequires: cmake gcc-c++ ctest gtk-doc libicu-devel icu-utils
%{?_with_system_tzdata:BuildRequires: tzdata >= %tzdata_ver}
%{?_with_bdb:BuildRequires: libdb4-devel}
%{?_enable_ical_glib:BuildRequires: libgio-devel libxml2-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_check:BuildRequires: python3-module-pygobject3}

%description
Libical is an Open Source implementation of the IETF's iCalendar
Calendaring and Scheduling protocols (RFC 2445, 2446, and 2447).
It parses iCal components and provides a C API for manipulating the
component properties, parameters, and subcomponents

%package devel
Summary: Files for developing applications that use libical
Group: Development/C
Requires: %name = %version-%release
# since 2.0.0
Requires: libicu-devel

%description devel
The header files and libtool library for developing applications that use
libical.

%package gir
Summary: GObject introspection data for the Libical
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Libical library.

%package gir-devel
Summary: GObject introspection devel data for the Libical
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the Libical library.

%package -n %name-glib
Summary: A GObject interface of the libical library
Group: System/Libraries
Requires: %name = %version-%release

%description -n %name-glib
This package provides Libical-Glib library with GObject bindings to
libical library.

%package -n %name-glib-devel
Summary: Files for developing applications that use Libical-Glib
Group: Development/C
Requires: %name-glib = %version-%release
Requires: %name-devel = %version-%release

%description -n %name-glib-devel
The header files and libtool library for developing applications that use
Libical-Glib.

%package -n %name-glib-gir
Summary: GObject introspection data for the Libical-Glib
Group: System/Libraries
Requires: %name-glib = %version-%release

%description -n %name-glib-gir
GObject introspection data for the Libical-Glib library.

%package -n %name-glib-gir-devel
Summary: GObject introspection devel data for the Libical-Glib
Group: Development/Other
BuildArch: noarch
Requires: %name-glib-gir = %version-%release
Requires: %name-glib-devel = %version-%release

%description -n %name-glib-gir-devel
GObject introspection devel data for the Libical-Glib library.

%package -n %name-glib-devel-doc
Summary: Development documentation for Libical-Glib
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-gloib-devel < %version-%release

%description -n %name-glib-devel-doc
This package contains development documentation for the Libical-Glib
library.

%prep
%setup
%patch -p1

%build
%cmake -DCMAKE_BUILD_TYPE:STRING="Release" \
	-DSHARED_ONLY:BOOL=ON \
	%{?_with_cxx:-DWITH_CXX_BINDINGS:BOOL=ON} \
	%{?_enable_ical_glib:-DICAL_GLIB:BOOL=ON} \
	%{?_enable_introspection:-DGOBJECT_INTROSPECTION:BOOL=ON} \
	%{?_enable_vala:-DICAL_GLIB_VAPI=ON} \
	%{?_disable_docs:-DICAL_BUILD_DOCS:BOOL=OFF} \
	%{?_with_system_tzdata:-DUSE_BUILTIN_TZDATA:BOOL=OFF}
%nil
%cmake_build

%install
%cmakeinstall_std

%check
LD_LIBRARY_PATH=%buildroot%_libdir %make test -C BUILD

%files
%doc TODO TEST THANKS
%_libdir/libical.so.*
%_libdir/libicalss.so.*
%_libdir/libicalvcal.so.*
%if_with cxx
%_libdir/libical_cxx.so.*
%_libdir/libicalss_cxx.so.*
%endif

%files devel
%doc doc/UsingLibical*
%_includedir/%name/
%_libdir/libical.so
%_libdir/libicalss.so
%_libdir/libicalvcal.so
%if_with cxx
%_libdir/libical_cxx.so
%_libdir/libicalss_cxx.so
%endif
%_pkgconfigdir/%name.pc
%_libdir/cmake/LibIcal/

%files -n %name-glib
%_libdir/%name-glib.so.*

%files -n %name-glib-devel
%_includedir/%name-glib/
%_libdir/%name-glib.so
%_pkgconfigdir/%name-glib.pc
%{?_enable_vala:%_vapidir/*}

%if_enabled introspection
%files gir
%_typelibdir/ICal-%api_ver.typelib

%files gir-devel
%_girdir/ICal-%api_ver.gir

%files -n %name-glib-gir
%_typelibdir/ICalGLib-%api_ver.typelib

%files -n %name-glib-gir-devel
%_girdir/ICalGLib-%api_ver.gir
%endif

%if_enabled docs
%files -n %name-glib-devel-doc
%_datadir/gtk-doc/html/%name-glib/
%endif


%changelog
