%def_enable snapshot
%def_disable python

Name: libimobiledevice
Version: 1.2.1
Release: alt0.2

Summary: Library for connecting to Apple iPhone and iPod touch
Group: System/Libraries
License: LGPLv2+
Url: http://www.libimobiledevice.org

%if_disabled snapshot
Source: %url/downloads/%name-%version.tar.bz2
%else
# VCS: https://github.com/libimobiledevice/libimobiledevice.git
Source: %name-%version.tar
%endif

%define plist_ver 1.11
%define usbmuxd_ver 1.0.9
%define cython_ver 0.18

BuildPreReq: libplist-devel >= %plist_ver
BuildPreReq: libusbmuxd-devel >= %usbmuxd_ver

BuildRequires: gcc-c++ autoconf-archive glib2-devel libxml2-devel libusb-devel libplistmm-devel
BuildRequires: libgnutls-devel libtasn1-devel libgcrypt-devel libssl-devel
BuildRequires: python-devel python-module-Cython >= %cython_ver python-module-libplist

%description
libimobiledevice is a library for connecting to Apple's iPhone or iPod touch devices

%package devel
Summary: Development package for libimobiledevice
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides files for development using libimobiledevice.

%package -n python-module-%name
Summary: Python bindings for libimobiledevice
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-%name
Python bindings for libimobiledevice.

%prep
%setup

%build
%autoreconf
%configure --disable-static \
	%{?_disable_python:--without-cython}
%make_build

%install
%makeinstall_std

%files
%_bindir/idevice*
%_libdir/*.so.*
%_man1dir/*
%doc AUTHORS NEWS README

%files devel
%_includedir/%name
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%if_enabled python
%files -n python-module-%name
%python_sitelibdir/imobiledevice.so
%exclude %python_sitelibdir/imobiledevice.la
%endif

%changelog
