%def_disable snapshot

%define _libexecdir %_prefix/libexec
%def_enable libwacom
%def_enable debug_gui
%def_disable documentation
%def_enable tests
%def_enable install_tests

Name: libinput
Version: 1.18.2
Release: alt1

Summary: Input devices library
Group: System/Libraries
License: MIT
Url: http://www.freedesktop.org/wiki/Software/libinput/

%if_disabled snapshot
Source: http://www.freedesktop.org/software/%name/%name-%version.tar.xz
%else
Vcs: https://gitlab.freedesktop.org/libinput/libinput.git
Source: %name-%version.tar
%endif

%add_python3_path %_libexecdir/%name

%define mtdev_ver 1.1.0
%define evdev_ver 0.4

BuildRequires(pre): meson rpm-build-python3
# for %%valgrind_arches
BuildRequires(pre): rpm-macros-valgrind
BuildRequires: gcc-c++
BuildRequires: libmtdev-devel >= %mtdev_ver libevdev-devel >= %evdev_ver
BuildRequires: libudev-devel libsystemd-devel
BuildRequires: libcheck-devel libgtk+3-devel
%{?_enable_libwacom:BuildRequires: libwacom-devel}
%{?_enable_debug_gui:BuildRequires: wayland-protocols}
%{?_enable_documentation:BuildRequires: doxygen graphviz}
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc gdb python3-module-pyparsing
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
}}

%description
libinput is a library that handles input devices for display servers and
other applications that need to directly deal with input devices.

It provides device detection, device handling, input device event
processing and abstraction so minimize the amount of custom input code
the user of libinput need to provide the common set of functionality
that users expect.

Input event processing includes scaling touch coordinates, generating
pointer events from touchpads, pointer acceleration, etc.

%package devel
Summary: libinput development package
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package tools
Summary: tools for %name
Group: Development/Tools
Requires: %name = %version-%release

%description tools
This package contains commandline tools from %name package.

%package tools-gui
Summary: libinput visual debug helper
Group: Development/Tools
Requires: %name = %version-%release
Requires: %name-tools = %version-%release

%description tools-gui
This package contains visual debug helper for %name.

%prep
%setup

%build
%meson %{?_enable_libwacom:-Dlibwacom=true} \
       %{?_enable_debug_gui:-Ddebug-gui=true} \
       %{?_disable_documentation:-Ddocumentation=false} \
       %{?_disable_tests:-Dtests=false} \
       %{?_enable_install_tests:-Dinstall-tests=true} \
       -Dudev-dir=/lib/udev
%meson_build

%install
%meson_install

%check
%meson_test

%files
%_libdir/%name.so.*
/lib/udev/%name-device-group
/lib/udev/%name-fuzz-extract
/lib/udev/%name-fuzz-to-zero
%_datadir/%name/
%_udevrulesdir/80-%name-device-groups.rules
%_udevrulesdir/90-%name-fuzz-override.rules
%doc COPYING README*

%files devel
%_includedir/%name.h
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%files tools
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/*
%{?_enable_debug_gui:%exclude %_libexecdir/%name/%name-debug-gui}
%_man1dir/%name.1.*
%_man1dir/%name-analyze.1*
%_man1dir/%name-analyze-per-slot-delta.1*
%_man1dir/%name-analyze-recording.1*
%_man1dir/%name-analyze-touch-down-state.1*
%_man1dir/%name-debug-events.1.*
%_man1dir/%name-debug-tablet.1.*
%_man1dir/%name-list-devices.1.*
%_man1dir/%name-measure.1.*
%_man1dir/%name-measure-fuzz.1.*
%_man1dir/%name-measure-touchpad-pressure.1.*
%_man1dir/%name-measure-touchpad-size.1*
%_man1dir/%name-measure-touchpad-tap.1.*
%_man1dir/%name-measure-touch-size.1.*
%_man1dir/%name-quirks.1.*
%_man1dir/%name-quirks-list.1.*
%_man1dir/%name-quirks-validate.1.*
%_man1dir/%name-record.1.*
%_man1dir/%name-replay.1.*
%{?_enable_tests:%_man1dir/%name-test-suite.1.*}
%_datadir/zsh/site-functions/_%{name}

%if_enabled debug_gui
%files tools-gui
%_libexecdir/%name/%name-debug-gui
%_man1dir/%name-debug-gui.1.*
%endif


%changelog
