%def_disable static
%define rname lcms2

Name: lib%rname
Version: 2.9
Release: alt1

Summary: Little cms color engine, version 2
License: %mit
Group: System/Libraries
Url: http://www.littlecms.com

# VCS: https://github.com/mm2/Little-CMS.git
#Source: http://downloads.sourceforge.net/lcms/%rname-%version.tar.gz
Source: %rname-%version.tar
Patch: %rname-2.5-alt-link.patch

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Sat Nov 06 2010
BuildRequires: gcc-c++ libjpeg-devel libtiff-devel zlib-devel

%package devel
Summary: LCMS 2 development environment
Group: Development/C
Requires: %name = %version-%release

%if_enabled static
%package devel-static
Summary: Static LCMS 2 library
Group: Development/C
Requires: %name-devel = %version-%release
%endif

%package -n lcms2-utils
Summary: Various %name-based utilities
Group: Graphics
Requires: %name = %version-%release

%description
This is a CMM engine to deal with color management stuff.

This package contains the library needed to run programs dynamically
linked with %name.

%description devel
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
applications which requires the LCMS 2 library.

%if_enabled static
%description devel-static
This is a CMM engine to deal with color management stuff.

This package is only needed if you plan to develop or compile
statically linked applications which requires the LCMS 2 library.
%endif

%description -n lcms2-utils
This is a CMM engine to deal with color management stuff.

This package contains various %name-based utilities

%prep
%setup -n %rname-%version
%patch

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
	%{subst_enable static} \
	--program-suffix=2
%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*
%doc AUTHORS README* COPYING

%files -n lcms2-utils
%_bindir/*
%_man1dir/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
