%def_enable static

Name: libusb
Version: 1.0.22
Release: alt1

Summary: Libusb is a library which allows userspace access to USB devices
License: LGPL
Group: System/Libraries

Url: http://libusb.info/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: doxygen libudev-devel

%description
Libusb is a library which allows userspace access to USB devices

%package devel
Summary: Libusb is a library which allows userspace access to USB devices
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains header files needed for the development
of programs that use libusb

%package devel-static
Summary: Libusb is a library which allows userspace access to USB devices
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides static libraries to use libusb

%package doc
Summary: Libusb is a library which allows userspace access to USB devices
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description doc
This package contains documentation for %name

%prep
%setup
%patch -p1
mkdir m4

%build
%autoreconf
%configure \
	%{subst_enable static}
%make_build
%make -C doc docs

%install
%makeinstall_std

mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/lib*.so; do
	t=$(readlink "$f")
	ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/lib*.so.* %buildroot/%_lib/

%files
/%_lib/%name-*.so.*
%doc AUTHORS README NEWS TODO

%files devel
%_libdir/%name-*.so
%_includedir/*
%_pkgconfigdir/%name-*.pc

%if_enabled static
%files devel-static
%_libdir/%name-*.a
%endif

%files doc
%doc doc/html

%changelog
