%define docdir %_docdir/%name

%define sover 1

Name: libvdpau
Version: 1.4
Release: alt1
Epoch: 1
Group: System/Libraries
Summary: VDPAU library
Url: http://cgit.freedesktop.org/~aplattner/libvdpau
License: Nvidia Free

Source: %name-%version.tar
Patch1: alt-allow-force-flash.patch

Provides: libvdpau1 = %EVR
Obsoletes: libvdpau1 < %EVR

# Automatically added by buildreq on Wed Jan 15 2014 (-bi)
# optimized out: elfutils fontconfig fonts-type1-urw ghostscript-common libX11-devel libstdc++-devel libwayland-client libwayland-server pkg-config python-base ruby ruby-stdlibs tex-common texlive-base texlive-base-bin texlive-common texlive-latex-base xorg-xproto-devel
#BuildRequires: doxygen fonts-ttf-google-droid-kufi fonts-ttf-google-droid-sans fonts-ttf-google-droid-serif gcc-c++ ghostscript-classic glibc-devel-static graphviz libXext-devel rpm-build-ruby xorg-dri2proto-devel
BuildRequires: doxygen gcc-c++ ghostscript-classic glibc-devel graphviz libXext-devel xorg-dri2proto-devel
BuildRequires: /usr/bin/pdftex meson

%description
This package contains the libvdpau wrapper library and the
libvdpau_trace debugging library. To actually use a VDPAU device, you
need a vendor-specific implementation library.  Currently, this is
always libvdpau_nvidia.  You can override the driver name by setting the
VDPAU_DRIVER environment variable.

%package devel
Group: Development/C
Summary: Development files for VDPAU library
Requires: %name = %{?epoch:%epoch:}%version-%release
Provides: libvdpau1-devel = %EVR
Obsoletes: libvdpau1-devel < %EVR

%description devel
Development files needed to build VDPAU applications

%package devel-doc
Group: Development/C
Summary: Documentation for VDPAU library
Requires: %name-devel = %version
BuildArch: noarch
Provides: libvdpau1-doc = %EVR
Obsoletes: libvdpau1-doc < %EVR

%description devel-doc
Documentation for VDPAU library

%prep
%setup
%patch1 -p1

%build
%meson
%meson_build

%install
%meson_install

%files
%doc AUTHORS COPYING
%config(noreplace) %_sysconfdir/vdpau_wrapper.cfg
%_libdir/libvdpau.so.%sover
%_libdir/libvdpau.so.%sover.*
%dir %_libdir/vdpau
%_libdir/vdpau/*.so
%_libdir/vdpau/*.so.*

%files devel
%_includedir/vdpau
%_libdir/libvdpau*.so
%_pkgconfigdir/*.pc

%files devel-doc
%dir %docdir
%docdir/html

%changelog
