Name: lightsquid
Version: 1.8
Release: alt2

Summary: Lite, small size and fast log analizer for squid proxy
Summary(ru_RU.UTF-8): Легкий, маленький и быстрый анализатор лога для прокси сервера squid
License: GPL
Group: Networking/WWW
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>

Url: http://lightsquid.sourceforge.net/
Source: http://prdownloads.sourceforge.net/lightsquid/%name-%version.tgz
BuildRequires: perl-CGI perl-GD2
Requires: webserver

BuildArch: noarch

%define apache_home %_var/www/html
%define lightsquid_confdir %_sysconfdir/lightsquid
%define lightdir %apache_home/lightsquid

##%set_strip_method none

%description
%name -- light squid report parser and visualyzer, generate sort of report
        light
        fast
        no database required
        no additional perl modules
        small disk usage
        template html - you can create you own look;

%description -l ru_RU.UTF-8
%name -- легкий, быстрый анализатор лога прокси сервера squid.
	 Не требует базы данных
	 Не требует дополнительных модулей perl
	 Использует шаблоны html

%prep
%setup -n %name-%version

%__subst "s|/var/www/html/lightsquid/lang|%_datadir/%name/lang|g"  lightsquid.cfg
%__subst "s|/var/www/html/lightsquid/tpl|%_datadir/%name/tpl|g" lightsquid.cfg
%__subst "s|/var/www/html/lightsquid/ip2name|%_datadir/%name/ip2name|g" lightsquid.cfg
%__subst "s|/var/www/html/lightsquid/report|%_localstatedir/%name|g" lightsquid.cfg
%__subst "s|\$cfgpath             =\"/var/www/html/lightsquid|\$cfgpath             =\"%lightsquid_confdir|g" lightsquid.cfg
%__subst "s|\$lockpath            =\$reportpath|\$lockpath            =\"%_lockdir/%name\"|g" lightsquid.cfg
%__subst 's|require "ip2name|require "$ip2namepath|g' lightparser.pl
%__subst "s|lightsquid.cfg|%lightsquid_confdir/lightsquid.cfg|g" *.cgi *.pl
%__subst "s|common.pl|%_datadir/%name/common.pl|g" *.cgi *.pl
%__subst "s|/etc/squid/users.txt|/etc/lightsquid/users.txt|g" ip2name/ip2name.*

iconv -f WINDOWS-1251 -t UTF8 lang/ru.lng > lang/ru-utf8.lng
%__subst "s|windows-1251|utf8|g" lang/ru-utf8.lng

	
%install
%__mkdir_p %buildroot%_sbindir
%__mkdir_p %buildroot%lightsquid_confdir
%__mkdir_p %buildroot%_sysconfdir/cron.d
%__mkdir_p %buildroot%_datadir/%name/{lang,ip2name,tpl}
%__mkdir_p %buildroot%_localstatedir/%name
%__mkdir_p %buildroot%lightdir
%__mkdir_p %buildroot%_lockdir/%name

# install bin
%__install -p -m 755 lightparser.pl %buildroot%_sbindir/

# install configs
%__install -p -m 644 lightsquid.cfg %buildroot%lightsquid_confdir/lightsquid.cfg
%__install -p -m 644 group.cfg.src %buildroot%lightsquid_confdir/group.cfg
%__install -p -m 644 realname.cfg %buildroot%lightsquid_confdir/realname.cfg

# install cron
%__cat << EOF > %buildroot%_sysconfdir/cron.d/lightsquid
55 * * * *     lightsquid /usr/sbin/lightparser.pl today
EOF


# install lib
%__install -p -m 644 common.pl %buildroot%_datadir/%name/
%__install -p -m 755 check-setup.pl %buildroot%_datadir/%name/
%__install -p -m 644 lang/[^A-Z]*.lng %buildroot%_datadir/%name/lang/
%__install -p -m 644 ip2name/[^A-Z]* %buildroot%_datadir/%name/ip2name/
%__cp -aRf tpl/[^A-Z]* %buildroot%_datadir/%name/tpl/
##%__install -p -m 644 tpl/[^A-Z]* %buildroot%_datadir/%name/tpl/

# install web
#%__install -p -m 644 .htaccess %buildroot%apache_home/%name/
%__install -p -m 755 [^A-Z]*.cgi %buildroot%apache_home/%name/

%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:
/usr/sbin/useradd -r -g %name -G squid -d %_localstatedir/%name -c 'Log parser lightsquid' -s /bin/false -n %name &> /dev/null ||:

%post
if [[ -d %lightdir/report ]]; then
    mv %lightdir/report/* %_localstatedir/%name
##    rm -f %lightdir/report
    echo "Reports move from %lightdir/report to %_localstatedir/%name"
fi
find %_localstatedir/%name -print0 | xargs -r0 chown %name:%name

%files
%doc doc/*
%_sbindir/*
%_datadir/%name
%dir %lightsquid_confdir
%config(noreplace) %verify(not md5 size mtime) %lightsquid_confdir/lightsquid.cfg
%config(noreplace) %verify(not md5 size mtime) %lightsquid_confdir/group.cfg
%config(noreplace) %verify(not md5 size mtime) %lightsquid_confdir/realname.cfg
%config %attr(0644,root,root) %_sysconfdir/cron.d/lightsquid
%dir %attr(1775,root,%name) %_localstatedir/%name
%dir %attr(1775,root,%name) %lightdir
%dir %attr(1775,root,%name) %_lockdir/%name
%attr(0755,%name,%name) %lightdir/*.cgi

%changelog
