%define _unpackaged_files_terminate_build 1

%def_disable debug
%def_disable profiling

%def_enable gui
%def_enable bz2
%def_enable lzo
%def_disable wxwidgets
%def_enable qt
%def_with flac
%def_without tools

%undefine _configure_gettext

Name: mkvtoolnix
Version: 43.0.0
Release: alt1

Summary: Tools to create, alter and inspect Matroska files
License: GPL-2
Group: Video
URL: https://mkvtoolnix.download/

# https://gitlab.com/mbunkus/mkvtoolnix.git
Source: %name-%version.tar

Provides: mkvmerge = %EVR

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++ boost-devel boost-filesystem-devel zlib-devel libmagic-devel
BuildRequires: libexpat-devel libvorbis-devel ImageMagick ruby ruby-stdlibs
BuildRequires: libcurl-devel libebml-devel >= 1.3.9 libmatroska-devel >= 1.5.2 libfmt-devel >= 5.3.0
BuildRequires: docbook-style-xsl xsltproc ruby-tools
BuildRequires: libpugixml-devel
BuildRequires: po4a

%{?_enable_wxwidgets:BuildRequires: libpango-devel libwxGTK3.1-devel}
%{?_enable_qt:BuildRequires: qt5-base-devel qt5-multimedia-devel cmark-devel}
%{?_enable_bz2:BuildRequires: bzlib-devel}
%{?_enable_lzo:BuildRequires: liblzo2-devel}
%{?_with_flac:BuildRequires: libflac-devel}

%description
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With these tools one can extract tracks/data from (mkvextract) Matroska
files and create (mkvmerge) Matroska files from other media files.

%if_enabled gui
%package gui
Summary: GUI for mkvmerge including a chapter editor
License: GPL-2
Group: Video
Provides: mmg = %EVR
Provides: mkvmerge-gui = %EVR
Obsoletes: mkvmerge-gui

%description gui
Matroska is a new multimedia file format aiming to become the new
container format for the future.
mkvmerge GUI is a wxWindows based GUI for mkvmerge. It offers easy
access to all of mkvmerge's options. All settings (e.g. source files,
track options etc) can be saved and restored. Included is a chapter
editor that can read OGM style and XML style chapter files, write XML
style chapter files and even read chapters from Matroska files and
write chapters directly to Matroska files.
%endif

%package -n mkvinfo
Summary: Tool for print information about tracks in Matroska files
License: GPL-2
Group: Video

%description -n mkvinfo
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With mkvinfo you can get information about Matroska files. This program
lists all tracks contained in a Matroska file including information
about the codecs used.

%if_with tools
%package tools
Summary: %name additional tools
Group: Video
Conflicts: %name < 2.4.0-alt1

%description tools
Matroska is a new multimedia file format aiming to become the new
container format for the future.
This package contains some additional tools.
%endif

%prep
%setup
rm -rf lib/pugixml

%build
./autogen.sh
%configure \
    --disable-option-checking \
    --disable-update-check \
    %{subst_enable debug} \
    %{subst_enable profiling} \
    %{subst_enable gui} \
    %{subst_enable bz2} \
    %{subst_enable lzo} \
    %{subst_enable wxwidgets} \
    %{subst_enable qt} \
    %{subst_with flac}

rake %{?_with_tools:TOOLS=1} V=1

%install
rake DESTDIR=%buildroot install

%if_with tools
install -m0755 -D src/tools/{base64tool,diracparser,ebml_validator,vc1parser} %buildroot%_bindir
%endif

%find_lang --with-man %name
%find_lang --with-man %name-gui
%find_lang --with-man mkvextract
%find_lang --with-man mkvmerge
%find_lang --with-man mkvpropedit
%find_lang --with-man mkvinfo

cat mkvextract.lang mkvmerge.lang mkvpropedit.lang >> %name.lang

%files -f %name.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%doc examples
%_bindir/mkvextract
%_bindir/mkvmerge
%_bindir/mkvpropedit
%_man1dir/mkvextract.*
%_man1dir/mkvmerge.*
%_man1dir/mkvpropedit.*
%_iconsdir/hicolor/*/apps/mkvextract.*
%_iconsdir/hicolor/*/apps/mkvmerge.*
%_iconsdir/hicolor/*/apps/mkvpropedit.*

%files -n mkvinfo -f mkvinfo.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%_bindir/mkvinfo
%_man1dir/mkvinfo.*
%_iconsdir/hicolor/*/apps/mkvinfo.*

%if_enabled gui
%files gui -f %name-gui.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%_bindir/%name-gui
%_man1dir/%name-gui.*
%_iconsdir/hicolor/*/apps/%name-gui.*
%_desktopdir/org.bunkus.%name-gui.desktop
%_xdgmimedir/packages/org.bunkus.%name-gui.xml
%_datadir/mkvtoolnix/sounds/*.ogg
%_datadir/metainfo/org.bunkus.%name-gui.appdata.xml
%endif

%if_with tools
%files tools
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%_bindir/base64tool
%_bindir/*parser
%_bindir/ebml_validator
%endif

%changelog
