%define _unpackaged_files_terminate_build 1

%def_disable debug
%def_disable prof
%def_disable werror
%def_enable ao
%def_enable shout
%def_enable tcp
%def_enable un
%def_enable curl
%def_disable ipv6
%def_enable fluidsynth
%def_disable wildmidi
%def_enable oss
%def_enable alsa
%def_enable jack
%def_enable pulse
%def_enable fifo
%def_enable mvp
%def_enable vorbis
%def_enable oggflac
%def_enable flac
%def_enable mad
%def_enable vorbisenc
%def_enable lame
%def_enable aac
%def_enable audiofile
%def_enable mikmod
%def_disable modplug
%def_enable faad
%def_disable mpc
%def_disable ffmpeg
%def_disable mp4
%def_enable wavpack
%def_enable id3
%def_enable lsr
%def_enable mms
%def_enable bzip2
%def_enable zip
%def_disable iso9660
%def_enable sqlite
%def_disable sidplay
%def_enable doc
%def_without tremor
%def_enable mpg123
%def_enable nfs
%def_enable webdav
%def_enable upnp
%def_enable mpdclient
%def_enable smbclient
%def_enable opus
# auto|avahi|bonjour|no
%define zeroconf avahi
%define mpd_user _mpd
%define mpd_group _mpd
#----------------------------------------------------------------------
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}

%if_with tremor
%set_disable shout
%set_disable oggflac
%endif
%{!?zeroconf:%define zeroconf no}

%define  Name MPD

Name:    mpd
Version: 0.20.23
Release: alt3

Summary: Music Player Daemon (%Name) allows remote access for playing music and managing playlists
License: %gpl2plus
Group:   Sound

Url:     http://musicpd.org
Source: %name-%version.tar
# VCS:   https://github.com/MusicPlayerDaemon/MPD.git
Source1: %name.conf
Source2: %name.sys.conf.in
Source3: %name.init.in
Source4: %name.logrotate
Source5: %name.tmpfile

BuildRequires(pre): rpm-build-licenses
BuildRequires: zlib-devel gcc-c++
%{?_enable_curl:BuildRequires: libcurl-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel >= 0.9.0}
%{?_enable_jack:BuildRequires: jackit-devel}
%{?_enable_ao:BuildRequires: libao-devel}
%{?_enable_shout:BuildRequires: libshout2-devel}
%{?_enable_audiofile:BuildRequires: libaudiofile-devel >= 0.1.7}
%{?_enable_mikmod:BuildRequires: libmikmod-devel >= 3.1.7}
%{?_enable_modplug:BuildRequires: libmmodplug-devel}
%{?_enable_faad:BuildRequires: libfaad-devel}
%{?_enable_flac:BuildRequires: libflac-devel >= 1.1.3}
%{?_enable_oggflac:BuildRequires: liboggflac-devel}
%{?_enable_id3:BuildRequires: libid3tag-devel}
%{?_enable_mad:BuildRequires: libmad-devel}
%{?_enable_vorbisenc:BuildRequires: libvorbis-devel}
%{?_enable_lame:BuildRequires: liblame-devel}
%{?_enable_mpc:BuildRequires: libmpcdec-devel}
%{?_enable_ffmpeg:BuildRequires: libavformat-devel}
%{?_enable_mp4:BuildRequires: libmp4ff-devel}
%{?_enable_wavpack:BuildRequires: libwavpack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_vorbis:BuildRequires: libvorbis-devel}
%{?_enable_lsr:BuildRequires: libsamplerate-devel}
%{?_enable_mms:BuildRequires: libmms-devel >= 0.4}
%{?_enable_sidplay:BuildRequires: libsidplay2-devel}
%{?_enable_zip:BuildRequires: zziplib-devel >= 0.13}
%{?_enable_bzip2:BuildRequires: bzlib-devel}
%{?_enable_iso9660:BuildRequires: libcdio-devel}
%{?_enable_sqlite:BuildRequires: libsqlite3-devel}
%{?_enable_fluidsynth:BuildRequires: libfluidsynth-devel}
%{?_enable_mpg123:BuildRequires: libmpg123-devel}
%{?_enable_nfs:BuildRequires: libnfs-devel}
%{?_enable_webdav:BuildRequires: libcurl-devel libexpat-devel}
%{?_enable_upnp:BuildRequires: libupnp-devel}
%{?_enable_mpdclient:BuildRequires: libmpdclient-devel}
%{?_enable_smbclient:BuildRequires: libsmbclient-devel}
%{?_enable_opus:BuildRequires: libopus-devel}
%{?_enable_doc:BuildRequires: docbook-dtds doxygen xmlto >= 0.0.21-alt2 /usr/bin/dot}
BuildRequires: systemd-devel
%if %zeroconf == avahi
BuildRequires: libavahi-glib-devel libdbus-devel
%endif

BuildRequires: boost-devel libicu-devel

%description
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC, Mod, and wave files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.

%if_enabled doc
%package doc
Summary: Music Player Daemon (%Name) documentation
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version

%description doc
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC, Mod, and wave files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.
This package contains %Name documentation.

%package doc-api
Summary: Music Player Daemon (%Name) documentation
Group: Development/Documentation
BuildArch: noarch

%description doc-api
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC, Mod, and wave files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.
This package contains %Name's API documentation.
%endif

%prep
%setup
[ $(rpmvercmp %{get_version libflac-devel} 1.1.3) -lt 0 ] || sed -i 's/AM_PATH_LIBOGGFLAC/AM_PATH_LIBFLAC/' configure.ac
# libmad.pc describes 'libmad', not 'mad'
sed -i 's/\[mad\]/[libmad]/' configure.ac

%build
%define _optlevel 3
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
    %{subst_enable debug} \
    %{subst_enable_to prof gprof} \
    %{subst_enable werror} \
    %{subst_with tremor} \
    %{subst_enable ao} \
    %{subst_enable shout} \
    %{subst_enable tcp} \
    %{subst_enable un} \
    %{subst_enable curl} \
    %{?_enable_curl:--enable-lastfm} \
    %{subst_enable ipv6} \
    %{subst_enable sun} \
    %{subst_enable oss} \
    %{subst_enable alsa} \
    %{subst_enable jack} \
    %{subst_enable pulse} \
    %{subst_enable fifo} \
    %{subst_enable mvp} \
    %{subst_enable vorbis} \
    %{subst_enable flac} \
    %{subst_enable oggflac} \
    %{subst_enable mad} \
    %{?_enable_lame:--enable-lame-encoder} \
    %{?_enable_vorbisenc:--enable-vorbis-encoder} \
    %{subst_enable aac} \
    %{subst_enable audiofile} \
    %{subst_enable mikmod} \
    %{subst_enable modplug} \
    %{subst_enable mpc} \
    %{subst_enable ffmpeg} \
    %{subst_enable mp4} \
    %{subst_enable wavpack} \
    %{subst_enable id3} \
    %{subst_enable lsr} \
    %{subst_enable mms} \
    %{subst_enable sidplay} \
    %{subst_enable bzip2} \
    %{subst_enable zip} \
    %{subst_enable iso9660} \
    %{subst_enable sqlite} \
    %{subst_enable fluidsynth} \
    %{subst_enable wildmidi} \
    %{subst_enable mpg123} \
    %{subst_enable nfs} \
    %{subst_enable webdav} \
    %{subst_enable upnp} \
    %{subst_enable mpdclient} \
    %{subst_enable smbclient} \
    %{subst_enable opus} \
    %{subst_enable_to doc documentation} \
    --with-systemdsystemunitdir=/lib/systemd/system \
    --with-zeroconf=%zeroconf \
    --docdir=%_docdir/%name-%version
%make_build
bzip2 --best --keep --force NEWS

%install
%makeinstall_std protocoldir=%_docdir/%name-%version/html
%if_enabled doc
ln -s html %buildroot%_docdir/%name-%version/protocol
%endif
install -d %buildroot{%_localstatedir/%name/playlists,{%_runtimedir,%_logdir}/%name,%_sysconfdir,%_initdir,%_tmpfilesdir}
sed -e "s|@localstatedir@|%_localstatedir|g" -e "s|@logdir@|%_logdir|g" %SOURCE1 > %buildroot%_sysconfdir/%name.conf
chmod 644 %buildroot%_sysconfdir/%name.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE2 > %buildroot%_sysconfdir/%name.sys.conf
chmod 640 %buildroot%_sysconfdir/%name.sys.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE3 > %buildroot%_initdir/%name
chmod 755 %buildroot%_initdir/%name
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE5 > %buildroot%_tmpfilesdir/%name.conf
chmod 644 %buildroot%_tmpfilesdir/%name.conf
install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/logrotate.d/%name
bzip2 --best %buildroot%_docdir/%name-%version/NEWS

%pre
%_sbindir/groupadd -r -f %mpd_group &>/dev/null ||:
%_sbindir/useradd -r -n -M -s /dev/null -d %_localstatedir/%name -g %mpd_group \
    -c "Music Player Daemon (%Name)" %mpd_user &>/dev/null ||:
%_sbindir/usermod -g %mpd_group -G audio %mpd_user &>/dev/null ||:

%post
%post_service %name ||:

%preun
%preun_service %name ||:

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/AUTHORS
%doc %_docdir/%name-%version/README.md
%doc %_docdir/%name-%version/COPYING
%doc %_docdir/%name-%version/%{name}conf.example
%if_disabled doc
%doc %_docdir/%name-%version/NEWS.*
%endif
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/%name.sys.conf
%config(noreplace) %_sysconfdir/logrotate.d/*
%_bindir/*
%_man1dir/*
%_man5dir/*
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
%attr(775,root,%mpd_group) %dir %_localstatedir/%name
%attr(775,root,%mpd_group) %dir %_localstatedir/%name/playlists
%attr(775,root,%mpd_group) %dir %_logdir/%name
%_iconsdir/hicolor/scalable/apps/%name.svg

%if_enabled doc
%files doc
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/NEWS.*
%doc %_docdir/%name-%version/html
%doc %_docdir/%name-%version/protocol
%doc %_docdir/%name-%version/user
%doc %_docdir/%name-%version/developer

%files doc-api
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/api
%endif


%changelog
