Name: nano
Version: 4.0
Release: alt2

Summary: a user-friendly editor, a Pico clone with enhancements
License: %gpl3plus/%fdl v1.2+
Group: Editors
Url: https://nano-editor.org/
Packager: Artem Zolochevskiy <azol@altlinux.org>

# https://www.nano-editor.org/dist/v4/nano-4.0.tar.xz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Tue Mar 19 2019
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config groff-base libncurses-devel libtinfo-devel pkg-config python-base sh4 xz
BuildRequires: groff-extra libmagic-devel libncursesw-devel
# Manually added
BuildRequires: desktop-file-utils

%description
GNU nano is a small and friendly text editor. It aims to emulate the
Pico text editor while also offering several enhancements.

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std

# install config file, include all existing syntax definitions
install -d %buildroot%_sysconfdir
sed 's/^# include "/include "/' doc/sample.nanorc > %buildroot%_sysconfdir/nanorc

# install doc files
install -pm644 AUTHORS IMPROVEMENTS NEWS README THANKS TODO %buildroot%_docdir/%name
xz %buildroot%_docdir/%name/NEWS
install -pm644 doc/sample.nanorc %buildroot%_docdir/%name/sample.nanorc
mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version

# install icons
install -Dpm644 %name-16x16.png %buildroot%_miconsdir/%name.png
install -Dpm644 %name-32x32.png %buildroot%_niconsdir/%name.png
install -Dpm644 %name-48x48.png %buildroot%_liconsdir/%name.png

# install .desktop file
desktop-file-install --dir %buildroot%_desktopdir %name.desktop

# list of language specific files
%find_lang --all-name %name

%files -f %name.lang
%doc %_docdir/%name-%version
%_bindir/*
%_datadir/%name/
%_infodir/*
%_man1dir/*
%_man5dir/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_desktopdir/*
%config(noreplace) %_sysconfdir/nanorc

%changelog
