%set_verify_elf_method textrel=relaxed
Name: ocaml-menhir
Version: 20181113
Release: alt1
Summary: LR(1) parser generator for the OCaml programming language.

Group: Development/ML
License: QPL
Url: http://gallium.inria.fr/~fpottier/menhir/
Source: menhir-%version.tar

BuildRequires(pre): ocaml
Provides: ocaml4-menhir = %EVR
Obsoletes: ocaml4-menhir

BuildRequires: ocaml-camlp4 ocaml-findlib ocaml-ocamlbuild python-module-google python3-base

%description
Menhir is a LR(1) parser generator for the OCaml programming language.
That is, Menhir compiles LR(1) grammar specifications down to OCaml
code. Menhir is 90 percent compatible with ocamlyacc. Legacy ocamlyacc
grammar specifications are accepted and compiled by Menhir. The
resulting parsers run and produce correct parse trees. However, parsers
that explicitly invoke functions in module Parsing behave slightly
incorrectly. For instance, the functions that provide access
to positions return a dummy position when invoked by a Menhir parser.
Porting a grammar specification from ocamlyacc to Menhir requires
replacing all calls to module Parsing with new Menhir-specific keywords.

%prep
%setup -q -n menhir-%version

%build
make PREFIX=/usr all

%install
mkdir -p %buildroot%_libdir/ocaml
make OCAMLFIND_DESTDIR=%buildroot%_libdir/ocaml PREFIX=%buildroot/usr install

mkdir -p %buildroot%_datadir/doc/%name-%version
mv %buildroot%_datadir/doc/menhir/* %buildroot%_datadir/doc/%name-%version/
rm -rf %buildroot%_datadir/doc/menhir
rm -rf %buildroot%_datadir/doc/%name-%version/src/

%files
%doc CHANGES.md
%doc demos
%doc INSTALLATION.md
%doc README.md
%doc LICENSE
%_bindir/*
%_man1dir/*
%dir %_datadir/menhir
%_datadir/menhir/*
%dir %_libdir/ocaml/menhirLib
%dir %_libdir/ocaml/menhirSdk
%_libdir/ocaml/menhirLib/*
%_libdir/ocaml/menhirSdk/*

%changelog
