%def_with pulse
%def_with qt5

Name: openal
Version: 1.19.1
Release: alt1

Summary: Open Audio Library

License: LGPLv2
Group: Sound
Url: http://kcat.strangesoft.net/openal.html

# Source-url: https://github.com/kcat/openal-soft/archive/openal-soft-%version.tar.gz
Source: %name-%version.tar

Patch0: openal-soft-1.17-alt-config.patch
Patch1: openal-soft-arm_neon-only-for-32bit.patch

BuildRequires: gcc-c++ cmake

BuildRequires: libalsa-devel
%{?_with_qt5:BuildRequires: qt5-base-devel}
%{?_with_pulse:BuildRequires: libpulseaudio-devel}
%if_without bootstrap
BuildRequires: libjack-devel libportaudio2-devel}
BuildRequires: libavdevice-devel libswresample-devel libswscale-devel
BuildRequires: libSDL2-devel libSDL2_mixer-devel libSDL_sound-devel
%endif

%description
OpenAL Soft is a cross-platform software implementation of the OpenAL 3D
audio API. It's built off of the open-sourced Windows version available
originally from the SVN repository at openal.org. OpenAL provides
capabilities for playing audio in a virtual 3d environment. Distance
attenuation, doppler shift, and directional sound emitters are among
the features handled by the API. More advanced effects, including air
absorption, low-pass filters, and reverb, are available through the
EFX extension. It also facilitates streaming audio, multi-channel buffers,
and audio capture.

%package -n lib%{name}1
Summary: Main library for OpenAL, a free 3D sound library
Group: Sound

%description -n lib%{name}1
This package contains the library needed to run programs dynamically
linked with OpenAL.

%package -n lib%name-devel
Summary: Headers for developing programs that will use OpenAL
Group: Development/C
Requires: lib%{name}1 = %version-%release
Obsoletes: lib%{name}1-devel < %version
Provides: lib%{name}1-devel = %version-%release

%description -n lib%name-devel
This package contains the headers that programmers will need to develop
applications which will use OpenAL, a free 3D audio library.

%package qt
Summary: Qt frontend for configuring OpenAL Soft
Group: Sound
Requires: lib%{name}1 = %EVR

%description qt
The %{name}-qt package contains alsoft-config, a Qt-based tool
for configuring OpenAL features.

%package tools
Summary: OpenAL Soft cli tools
Group: Sound
Requires: lib%{name}1 = %EVR

%description tools
The %{name}-tools package contains various OpenAL command line tools.

%prep
%setup
%ifarch %e2k
sed -i 's,-Winline,,' CMakeLists.txt
%endif

%build
%cmake_insource \
	-DALSOFT_REQUIRE_OSS=OFF \
	-DALSOFT_CONFIG=ON

%ifarch %e2k
# TODO: reintroduce if possible
sed -i '/^#define HAVE_SSE/d' config.h
%endif

%make_build

%install
%makeinstall_std
#rm -f %buildroot%_bindir/%name-info
mkdir -p %buildroot%_sysconfdir/%name/
install -m0644 alsoftrc.sample %buildroot%_sysconfdir/%name/alsoft.conf

%files -n lib%{name}1
%_bindir/openal-info
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/alsoft.conf
%_datadir/%name/
%_libdir/*.so.1
%_libdir/*.so.1.*.*

%if_without bootstrap
%files tools
/usr/bin/alffplay
/usr/bin/alhrtf
/usr/bin/allatency
/usr/bin/alloopback
/usr/bin/almultireverb
/usr/bin/alplay
/usr/bin/alreverb
/usr/bin/alstream

%_bindir/altonegen
%_bindir/alrecord
%_bindir/makehrtf
#_bindir/bsincgen
%endif

%files -n lib%name-devel
%_includedir/AL/
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/OpenAL/OpenALConfig-relwithdebinfo.cmake
%_libdir/cmake/OpenAL/OpenALConfig.cmake

%if_with qt5
%files qt
%_bindir/alsoft-config
%endif

%changelog
