Name: papi
Version: 5.7.0
Release: alt1

Summary: Performance Application Programming Interface

License: BSD-like
Group: Development/Tools
Url: http://icl.cs.utk.edu/papi/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%define tagversion %(echo "%version" | sed -e "s|\\.|-|g")
# Source-url: https://bitbucket.org/icl/papi/get/papi-%tagversion-t.tar.bz2
Source: %name-%version.tar

Requires: lib%name = %EVR

BuildPreReq: libncurses-devel gcc-fortran /proc libsensors3-devel libgomp-devel
BuildPreReq: libltdl-devel doxygen graphviz

%description
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

%package -n lib%name
Summary: Shared libraries of PAPI (Performance Application Programming Interface)
Group: System/Libraries

%description -n lib%name
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains shared libraries of PAPI.

%package -n lib%name-devel
Summary: Development files of Performance Application Programming Interface
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains development files of PAPI.

%package doc
Summary: Documentation for Performance Application Programming Interface
Group: Documentation
#BuildArch: noarch

%description doc
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains documentation for PAPI.

%prep
%setup

rm -fR src/perfctr-*
cp -f src/Rules.pfm src/Rules.perfctr
cp -f src/Rules.pfm src/Rules.perfctr-pfm

%__subst 's|-Xlinker "-rpath" -Xlinker "\$(LIBDIR)"||' src/configure.in

%build
cd src

pushd components/lmsensors
%autoreconf
%configure \
	--with-sensors_incdir=%_includedir/sensors \
	--with-sensors_libdir=%_libdir
popd

#cp Makefile.inc Makefile.inc.bak
#sed -i -e 's/\-Werror//g' libpfm-3.?/config.mk
%add_optflags %optflags_shared
%autoreconf
%configure \
	--with-ffsll \
	--with-static-lib=no \
        --with-shlib \
        --with-shlib-tools=yes \
	--with-virtualtimer=clock_thread_cputime_id \
	--with-perf-events \
	--with-libpfm4 \
	--with-components="appio coretemp lmsensors mx net rapl stealtime"
#cp -f Makefile.inc.bak Makefile.inc
#make libpapi.a
LD_LIBRARY_PATH=$(pwd)/libpfm4/lib %make_build

%make -C ../doc html man

%install
cd src
%makeinstall_std
%make_install DESTDIR=%buildroot install-man

install -d %buildroot%_docdir/%name
cp -fR ../doc/html/* %buildroot%_docdir/%name/

ln -s libpapi.so %buildroot%_libdir/libpapi64.so
ln -s libpfm.so %buildroot%_libdir/libpfm64.so

rm -f %buildroot%_libdir/*.a

%files
%doc *.txt README
%_bindir/*
%_man1dir/*
%_datadir/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*
%_pkgconfigdir/*.pc

%files doc
%_docdir/%name

%changelog
