%define libname libpci

Name: pciutils
Version: 3.7.0
Release: alt1

Summary: Linux PCI utilities
License: GPLv2
Group: System/Kernel and hardware

Url: http://mj.ucw.cz/sw/pciutils/
# git://git.kernel.org/pub/scm/utils/pciutils/pciutils.git
Source: %name-%version.tar

Requires: pciids
Requires: %libname = %version-%release
BuildRequires(pre):rpm-build-ubt

# http://www.kernel.org/pub/software/utils/pciutils/
# http://git.kernel.org/?p=utils/pciutils/pciutils.git
# git://git.kernel.org/pub/scm/utils/pciutils/pciutils.git
# http://git.ucw.cz/gitweb/?p=pciutils.git
# git://git.ucw.cz/pciutils.git

Summary(ru_RU.UTF-8): Утилиты для работы с PCI в Linux
Summary(uk_UA.UTF-8): Утиліти для роботи з PCI в Linux

%description
This package contains various utilities for inspecting
and setting devices connected to the PCI bus.

%description -l ru_RU.UTF-8
Этот пакет содержит несколько утилит для просмотра и настройки
устройств, подключенных к шине PCI.

%description -l uk_UA.UTF-8
Цей пакунок містить декілька утиліт для перегляду й налаштування
пристроїв, які підключено до шини PCI.

%package -n %libname
Summary: Linux PCI library
Group: System/Libraries

%description -n %libname
This package contains shared library for inspecting and setting
devices connected to the PCI bus.

%package -n %libname-devel
Summary: Linux PCI development library
Group: Development/C
Requires: %libname = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 2.99.1 %name-devel-static < 2.99.1

%description -n %libname-devel
This package contains PCI library headers.

%prep
%setup

%build
%make_build \
	SHARED=yes \
	OPT="%optflags" \
	PREFIX=%_prefix \
	IDSDIR=%_datadir/misc

%install
%make_install \
	SHARED=yes \
	DESTDIR=%buildroot \
	PREFIX=%_prefix \
	install install-lib

mv %buildroot%_sbindir %buildroot%_bindir
[ "%_libdir" = "%_prefix/lib" ] || {
	mv %buildroot%_prefix/lib %buildroot%_libdir
}

%files
%_bindir/lspci
%_bindir/setpci
%_man8dir/lspci*
%_man8dir/setpci*
%doc README TODO ChangeLog *.lsm

%files -n %libname
%_libdir/*.so.*

%files -n %libname-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man7dir/pcilib*

%changelog
