%define _unpackaged_files_terminate_build 1

%global backends %nil
%define _pkgdocdir %_docdir/%name

Name: pdns
Version: 4.2.2
Release: alt4.1
Summary: A modern, advanced and high performance authoritative-only nameserver
Group: System/Servers
License: GPLv2
Url: http://powerdns.com
Source0: %name-%version.tar
Patch0: pdns-disable-secpoll.patch
Patch1: %name-%version-alt-boost-1.73.0-compat.patch
Patch2: %name-%version-upstream-gcc10-compat-1.patch
Patch3: %name-%version-upstream-gcc10-compat-2.patch
Patch4: %name-%version-alt-fix-missing-include.patch

BuildRequires: gcc-c++ boost-program_options-devel curl libcurl-devel libsqlite3-devel
BuildRequires: systemd-devel /bin/systemctl
BuildRequires: boost-devel
BuildRequires: liblua5-devel
BuildRequires: bison flex ragel
BuildRequires: libzeromq-devel
BuildRequires: openssl-devel
BuildRequires: libprotobuf-devel
BuildRequires: protobuf-compiler
BuildRequires: libkrb5-devel
Provides: powerdns = %version-%release
%global backends %backends bind random

%description
The PowerDNS Nameserver is a modern, advanced and high performance
authoritative-only nameserver. It is written from scratch and conforms
to all relevant DNS standards documents.
Furthermore, PowerDNS interfaces with almost any database.

%package tools
Summary: Extra tools for %name
Group: System/Servers

%description tools
This package contains the extra tools for %name

%package backend-mysql
Summary: MySQL backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: libmysqlclient-devel
%global backends %backends gmysql

%description backend-mysql
This package contains the gmysql backend for %name

%package backend-postgresql
Summary: PostgreSQL backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: postgresql-devel
%global backends %backends gpgsql

%description backend-postgresql
This package contains the gpgsql backend for %name

%package backend-pipe
Summary: Pipe backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends pipe

%description backend-pipe
This package contains the pipe backend for %name

%package backend-remote
Summary: Remote backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends remote

%description backend-remote
This package contains the remote backend for %name

%package backend-ldap
Summary: LDAP backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: openldap-devel
%global backends %backends ldap

%description backend-ldap
This package contains the ldap backend for %name

%package backend-lua
Summary: LUA backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends lua

%description backend-lua
This package contains the lua backend for %name

%package backend-lua2
Summary: LUA2 backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends lua2

%description backend-lua2
This package contains the lua2 backend for %name

%package backend-sqlite
Summary: SQLite backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends gsqlite3

%description backend-sqlite
This package contains the SQLite backend for %name

%package backend-opendbx
Summary: OpenDBX backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: opendbx-devel
%global backends %backends opendbx

%description backend-opendbx
This package contains the opendbx backend for %name

%package backend-geoip
Summary: GeoIP backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: libGeoIP-devel
BuildRequires: libyaml-cpp-devel
%global backends %backends geoip

%description backend-geoip
This package contains the GeoIP backend for %name

%package backend-mydns
Summary: MyDNS backend for %name
Group: System/Servers
Requires: %name = %version-%release
%global backends %backends mydns

%description backend-mydns
This package contains the MyDNS backend for %name

%package backend-tinydns
Summary: TinyDNS backend for %name
Group: System/Servers
Requires: %name = %version-%release
BuildRequires: tinycdb-devel
%global backends %backends tinydns

%description backend-tinydns
This package contains the TinyDNS backend for %name

%package ixfrdist
Summary: A program to redistribute zones over AXFR and IXFR
Group: System/Servers

BuildRequires: libyaml-cpp-devel

%description ixfrdist
This package contains the ixfrdist program.


%prep
%setup
%patch0 -p1 -b .disable-secpoll
%patch1 -p2
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
export CPPFLAGS="-DLDAP_DEPRECATED"
export BUILDER_VERSION=%version
export PDNS_TEST_NO_IPV6=1

%autoreconf
%configure \
	--sysconfdir=%_sysconfdir/%name \
	--disable-static \
	--disable-dependency-tracking \
	--disable-silent-rules \
	--with-modules='' \
	--with-lua \
	--enable-lua-records \
	--with-dynmodules='%backends' \
	--enable-tools \
	--enable-remotebackend-zeromq \
	--enable-unit-tests \
	--enable-reproducible \
	--enable-systemd --with-systemd=%_unitdir \
	--enable-ixfrdist

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/%name/*.la
mv %buildroot%_sysconfdir/%name/pdns.conf{-dist,}

chmod 600 %buildroot%_sysconfdir/%name/pdns.conf

# rename zone2ldap to pdns-zone2ldap (#1193116)
mv %buildroot%_bindir/zone2ldap %buildroot%_bindir/pdns_zone2ldap
mv %buildroot%_man1dir/zone2ldap.1 %buildroot%_man1dir/pdns_zone2ldap.1

# change user/group to pdns
# change default backend to bind
sed -i \
    -e 's/# setuid=/setuid=pdns/' \
    -e 's/# setgid=/setgid=pdns/' \
    -e 's/# launch=/launch=bind/' \
    %buildroot%_sysconfdir/%name/pdns.conf

rm %buildroot%_bindir/stubquery

mkdir -p %buildroot%_localstatedir/%name

%check
%make_build -C pdns check || cat pdns/test-suite.log

%pre

%_sbindir/groupadd -r -f %name
%_sbindir/useradd -M -r -d %_localstatedir/%name -s /bin/false -c "PowerDNS user" -g %name %name >/dev/null 2>&1 ||:

%post
%post_service pdns

%preun
%preun_service pdns

%files
%doc COPYING README
%_bindir/pdns_control
%_bindir/pdnsutil
%_bindir/pdns_zone2ldap
%_bindir/zone2sql
%_bindir/zone2json
%_sbindir/pdns_server
%_man1dir/pdns_control.1.*
%_man1dir/pdns_server.1.*
%_man1dir/zone2sql.1.*
%_man1dir/zone2json.1.*
%_man1dir/pdns_zone2ldap.1.*
%_man1dir/pdnsutil.1.*
%_unitdir/pdns.service
%_unitdir/pdns@.service
%_libdir/%name/libbindbackend.so
%_libdir/%name/librandombackend.so
%dir %_libdir/%name
%dir %_sysconfdir/%name
%dir %attr(0750, root, %name) %_localstatedir/%name
%config(noreplace) %_sysconfdir/%name/pdns.conf

%files tools
%_bindir/calidns
%_bindir/dnsbulktest
%_bindir/dnsgram
%_bindir/dnspcap2calidns
%_bindir/dnspcap2protobuf
%_bindir/dnsreplay
%_bindir/dnsscan
%_bindir/dnsscope
%_bindir/dnstcpbench
%_bindir/dnswasher
%_bindir/dumresp
%_bindir/ixplore
%_bindir/pdns_notify
%_bindir/nproxy
%_bindir/nsec3dig
%_bindir/saxfr
%_bindir/sdig
%_man1dir/calidns.1.*
%_man1dir/dnsbulktest.1.*
%_man1dir/dnsgram.1.*
%_man1dir/dnspcap2calidns.1.*
%_man1dir/dnspcap2protobuf.1.*
%_man1dir/dnsreplay.1.*
%_man1dir/dnsscan.1.*
%_man1dir/dnsscope.1.*
%_man1dir/dnstcpbench.1.*
%_man1dir/dnswasher.1.*
%_man1dir/dumresp.1.*
%_man1dir/ixplore.1.*
%_man1dir/pdns_notify.1.*
%_man1dir/nproxy.1.*
%_man1dir/nsec3dig.1.*
%_man1dir/saxfr.1.*
%_man1dir/sdig.1.*

%files backend-mysql
%_pkgdocdir/schema.mysql.sql
%_pkgdocdir/dnssec-3.x_to_3.4.0_schema.mysql.sql
%_pkgdocdir/nodnssec-3.x_to_3.4.0_schema.mysql.sql
%_pkgdocdir/3.4.0_to_4.1.0_schema.mysql.sql
%_pkgdocdir/4.1.0_to_4.2.0_schema.mysql.sql
%_libdir/%name/libgmysqlbackend.so

%files backend-postgresql
%_pkgdocdir/schema.pgsql.sql
%_pkgdocdir/dnssec-3.x_to_3.4.0_schema.pgsql.sql
%_pkgdocdir/nodnssec-3.x_to_3.4.0_schema.pgsql.sql
%_pkgdocdir/3.4.0_to_4.1.0_schema.pgsql.sql
%_pkgdocdir/4.1.0_to_4.2.0_schema.pgsql.sql
%_libdir/%name/libgpgsqlbackend.so

%files backend-pipe
%_libdir/%name/libpipebackend.so

%files backend-remote
%_libdir/%name/libremotebackend.so

%files backend-ldap
%_pkgdocdir/dnsdomain2.schema
%_pkgdocdir/pdns-domaininfo.schema
%_libdir/%name/libldapbackend.so

%files backend-lua
%_libdir/%name/libluabackend.so

%files backend-lua2
%_libdir/%name/liblua2backend.so

%files backend-sqlite
%_pkgdocdir/schema.sqlite3.sql
%_pkgdocdir/dnssec-3.x_to_3.4.0_schema.sqlite3.sql
%_pkgdocdir/nodnssec-3.x_to_3.4.0_schema.sqlite3.sql
%_pkgdocdir/3.4.0_to_4.0.0_schema.sqlite3.sql
%_pkgdocdir/4.0.0_to_4.2.0_schema.sqlite3.sql
%_libdir/%name/libgsqlite3backend.so

%files backend-opendbx
%_libdir/%name/libopendbxbackend.so

%files backend-geoip
%_libdir/%name/libgeoipbackend.so

%files backend-mydns
%_pkgdocdir/schema.mydns.sql
%_libdir/%name/libmydnsbackend.so

%files backend-tinydns
%_libdir/%name/libtinydnsbackend.so

%files ixfrdist
%_bindir/ixfrdist
%_man1dir/ixfrdist.*
%_man5dir/ixfrdist.yml.*
%_sysconfdir/%name/ixfrdist.example.yml
%_unitdir/ixfrdist.service
%_unitdir/ixfrdist@.service

%changelog
