# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-MinimumVersion
Version:        1.38
Release:        alt1_18
Summary:        Find a minimum required version of perl for Perl code
License:        GPL+ or Artistic
Group:          Development/Other
URL:            https://metacpan.org/release/Perl-MinimumVersion
Source0:        https://cpan.metacpan.org/authors/id/N/NE/NEILB/Perl-MinimumVersion-%{version}.tar.gz

BuildArch:      noarch

BuildRequires: rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# Run-time and tests:
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Params/Util.pm)
BuildRequires: perl(Perl/Critic/Utils.pm)
BuildRequires: perl(PPI.pm)
BuildRequires: perl(PPI/Util.pm)
BuildRequires: perl(PPIx/Regexp.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildRequires: perl(version.pm)
BuildRequires: perl(warnings.pm)
%if !%{defined perl_bootstrap}
BuildRequires: perl(File/Find/Rule.pm)
BuildRequires: perl(File/Find/Rule/Perl.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Script.pm)
%endif

# Remove under-specified dependencies



Source44: import.info
%filter_from_requires /^perl(version\\)$/d
%filter_from_requires /^perl(Params.Util\\)$/d
%filter_from_requires /^perl >= 0:5.005$/d

%description
Find a minimum required version of perl for Perl code

%prep
%setup -q -n Perl-MinimumVersion-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
%if !%{defined perl_bootstrap}
make test
%endif

%files
%doc Changes
%doc --no-dereference LICENSE
%{_bindir}/*
%{perl_vendor_privlib}/Perl
%{_mandir}/man1/*

%changelog
