Name: pudb
Version: 2017.1.4
Release: alt1
%setup_python_module %name
Summary: A full-screen, console-based Python debugger
License: MIT
Group: Development/Debuggers
Url: http://pypi.python.org/pypi/pudb
Source: %name-%version.tar.gz
BuildArch: noarch
Requires: %packagename

# Automatically added by buildreq on Wed Mar 15 2017
# optimized out: python-base python-devel python-modules python-modules-compiler python-modules-ctypes python-modules-email python3 python3-base
BuildRequires: python-module-setuptools python3-dev python3-module-setuptools

%description
PuDB is a full-screen, console-based visual debugger for Python.

Its goal is to provide all the niceties of modern GUI-based debuggers in
a more lightweight and keyboard-friendly package. PuDB allows you to
debug code right where you write and test it--in a terminal. If you've
worked with the excellent (but nowadays ancient) DOS-based Turbo Pascal
or C tools, PuDB's UI might look familiar.

%package -n pudb3
Group: Development/Debuggers
BuildArch: noarch
Summary: A full-screen, console-based Python3 debugger
Requires: python3-module-%name

%description -n pudb3
PuDB is a full-screen, console-based visual debugger for Python3.

Its goal is to provide all the niceties of modern GUI-based debuggers in
a more lightweight and keyboard-friendly package. PuDB allows you to
debug code right where you write and test it--in a terminal. If you've
worked with the excellent (but nowadays ancient) DOS-based Turbo Pascal
or C tools, PuDB's UI might look familiar.

%package -n %packagename
Group: Development/Python
BuildArch: noarch
Summary: Supplemental python module for %name, %summary
%description -n %packagename
Supplemental python module for %name, %summary

%package -n python3-module-%name
Group: Development/Python
BuildArch: noarch
Summary: Supplemental python3 module for %name, %summary
%description -n python3-module-%name
Supplemental python module for %name, %summary

%prep
%setup

cat > %name.sh <<@@@
#!/bin/sh
python -m pudb.run "\$@"
@@@

sed 's/python/python3/g' %name.sh > %{name}3.sh

%build
%python_build -b build2
%python3_build -b build3

%install
rm -f build && ln -s build2 build
%python_install
rm -f build && ln -s build3 build
%python3_install
install -D -m755 %name.sh %buildroot/%_bindir/%name
install -D -m755 %{name}3.sh %buildroot/%_bindir/%{name}3

%files
%doc README.rst
%_bindir/%name

%files -n pudb3
%doc README.rst
%_bindir/%{name}3

%files -n %packagename
%doc test
%python_sitelibdir_noarch/*

%files -n python3-module-%name
%doc test
%python3_sitelibdir_noarch/*

%changelog
