%define pre b1
%define oname OpenGLContext

%def_without bootstrap

Name: python-module-%oname
Version: 2.3.0
Release: alt3.1

Summary: Demonstration and testing contexts for PyOpenGL
Group: Development/Python
License: BSD-like
Url: http://pyopengl.sourceforge.net/context
BuildArch: noarch

Source: http://prdownloads.sourceforge.net/pyopengl/%oname-%version%pre.tar.gz

%add_python_req_skip win32con win32ui FXPy

BuildRequires: python-module-html5lib python-module-matplotlib time
BuildRequires: python-tools-2to3 python-module-docutils

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools


%description
Demonstration and Testing Contexts for PyOpenGL

OpenGLContext includes rendering contexts (including navigation)
for wxPython, PyGame and GLUT, as well as a partial context for
Tkinter.  It also includes support for rendering TrueType fonts,
and a significant subset of VRML97.  It provides fairly extensive
VRML97 scenegraph model.  It also includes the bulk of the tests
used to maintain and extend PyOpenGL.

%package -n python3-module-%oname
Summary: Demonstration and testing contexts for PyOpenGL
Group: Development/Python3
%add_python3_req_skip pygame win32con win32ui fontTools
%add_python3_req_skip FXPy.fox wx wx.py ttfquery

%description -n python3-module-%oname
Demonstration and Testing Contexts for PyOpenGL

OpenGLContext includes rendering contexts (including navigation)
for wxPython, PyGame and GLUT, as well as a partial context for
Tkinter.  It also includes support for rendering TrueType fonts,
and a significant subset of VRML97.  It provides fairly extensive
VRML97 scenegraph model.  It also includes the bulk of the tests
used to maintain and extend PyOpenGL.

%package -n python3-module-%oname-tests
Summary: Tests for %name
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Demonstration and Testing Contexts for PyOpenGL

OpenGLContext includes rendering contexts (including navigation)
for wxPython, PyGame and GLUT, as well as a partial context for
Tkinter.  It also includes support for rendering TrueType fonts,
and a significant subset of VRML97.  It provides fairly extensive
VRML97 scenegraph model.  It also includes the bulk of the tests
used to maintain and extend PyOpenGL.

This package contains tests for %name.

%package tests
Summary: Tests for %name
Group: Development/Python
Requires: %name = %version-%release

%description tests
Demonstration and Testing Contexts for PyOpenGL

OpenGLContext includes rendering contexts (including navigation)
for wxPython, PyGame and GLUT, as well as a partial context for
Tkinter.  It also includes support for rendering TrueType fonts,
and a significant subset of VRML97.  It provides fairly extensive
VRML97 scenegraph model.  It also includes the bulk of the tests
used to maintain and extend PyOpenGL.

This package contains tests for %name.

%prep
%setup -n %oname-%version%pre

rm -rf ../python3
cp -fR . ../python3

%build
%python_build

pushd ../python3
find -type f -name '*.py' -exec 2to3 -w -n '{}' +
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%files
%doc docs
%python_sitelibdir/%oname/
%python_sitelibdir/*egg-info/

%files -n python3-module-%oname
%python3_sitelibdir/%oname/
%python3_sitelibdir/*egg-info/


%changelog
