%define modname dbusmock
%define _name python-%modname
%def_enable check

Name: python-module-dbusmock
Version: 0.18.3
Release: alt1

Summary: mock D-Bus objects for tests
License: LGPLv3
Group: Development/Python
Url: https://github.com/martinpitt/python-dbusmock
# https://pypi.python.org/pypi/%_name

Source: %url/releases/download/%version/%_name-%version.tar.gz
#Source: https://pypi.io/packages/source/p/%_name/%_name-%version.tar.gz

BuildArch: noarch

%setup_python_module %modname

Requires: dbus

BuildRequires: rpm-build-gir
BuildRequires: python-devel python-module-setuptools
# for python3
BuildRequires: rpm-build-python3 python3-devel python3-module-setuptools
%if_enabled check
BuildRequires: /proc dbus-tools-gui %_bindir/notify-send %_bindir/nmcli upower
BuildRequires: python-module-setuptools python-module-nose python-module-dbus python-modules-json
BuildRequires: python3-module-setuptools python3-module-nose python3-module-dbus
BuildRequires: python3-module-pyflakes
# polkit tests fail since 0.115-alt4
#BuildRequires: polkit
%endif

%description
With this program/Python library you can easily create mock objects on
D-Bus. This is useful for writing tests for software which talks to D-Bus
services such as upower, systemd, ConsoleKit, gnome-session or others,
and it is hard (or impossible without root privileges) to set the state
of the real services to what you expect in your tests.

See %_docdir/%name-%version/README.rst for more information.

%package -n python3-module-%modname
Summary: mock D-Bus objects for tests (python3 version)
Group: Development/Python3

%description -n python3-module-%modname
With this program/Python library you can easily create mock objects on
D-Bus. This is useful for writing tests for software which talks to D-Bus
services such as upower, systemd, ConsoleKit, gnome-session or others,
and it is hard (or impossible without root privileges) to set the state
of the real services to what you expect in your tests.

See %_docdir/%name-%version/README.rst for more information.


%prep
%setup -n %_name-%version -a0
mv %_name-%version py3build

%build
%python_build
pushd py3build
%python3_build
popd

%install
%python_install
pushd py3build
%python3_install
popd

%if_enabled check
%check
python setup.py test
pushd py3build
python3 setup.py test
popd
%endif

%files
%python_sitelibdir_noarch/%modname/
%doc NEWS README.* PKG-INFO

%files -n python3-module-%modname
%python3_sitelibdir_noarch/%modname/


%changelog
