%define _unpackaged_files_terminate_build 1

%define oname gitdb

%def_with python3

Name: python-module-%oname
Version: 2.0.3
Release: alt1.qa1%ubt
Summary: IO of git-style object databases
License: BSD
BuildArch: noarch
Group: Development/Python
Url: https://pypi.python.org/pypi/gitdb/

# https://github.com/gitpython-developers/gitdb.git
Source: %name-%version.tar
Patch1: %oname-alt-build.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: git-core
BuildRequires: python-devel python-module-setuptools
BuildRequires: python2.7(smmap)
BuildRequires: python2.7(nose)
BuildRequires: python2.7(coverage)
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3(smmap)
BuildRequires: python3(nose)
BuildRequires: python3(coverage)
%endif

%description
IO of git-style object databases.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
IO of git-style object databases.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: IO of git-style object databases
Group: Development/Python3

%description -n python3-module-%oname
IO of git-style object databases.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
IO of git-style object databases.

This package contains tests for %oname.
%endif

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
IO of git-style object databases.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
IO of git-style object databases.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx doc
ln -s ../objects.inv doc/source/

%build
%add_optflags -fno-strict-aliasing
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%make -C doc pickle
%make -C doc html

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/

%check
# needed for tests
git config --global user.email "darktemplar at altlinux.org"
git config --global user.name "darktemplar"

git init
git add -A
git commit -m "%version"
git tag %version -m "%version"

# TODO: This test doesn't work, remove it for now
rm -f gitdb/test/performance/test_pack_streaming.py

%make coverage

%if_with python3
pushd ../python3

# needed for tests
git init
git add -A
git commit -m "%version"
git tag %version -m "%version"

# TODO: This test doesn't work, remove it for now
rm -f gitdb/test/performance/test_pack_streaming.py

%make coverage PYTHON=python3 TESTRUNNER=$(which nosetests3)
popd
%endif

%files
%doc AUTHORS *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle
%exclude %python_sitelibdir/%oname/test

%files tests
%python_sitelibdir/%oname/test

%files pickles
%python_sitelibdir/%oname/pickle

%files docs
%doc doc/build/html/*

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/test
%endif

%changelog
