%define _unpackaged_files_terminate_build 1
%define oname pexpect

%def_with check

Name: python-module-%oname
Version: 4.6
Release: alt3

Summary: Pexpect is a pure Python Expect. It allows easy control of other applications
License: Python Software Foundation License
Group: Development/Python
# Source-git: https://github.com/pexpect/pexpect.git
Url: https://pypi.python.org/pypi/pexpect

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-objects.inv
BuildRequires: python-module-ptyprocess
BuildRequires: python3-module-ptyprocess

%if_with check
BuildRequires: /dev/pts
BuildRequires: man-db
BuildRequires: openssl
BuildRequires: python-module-pytest
BuildRequires: python-module-pyte
BuildRequires: python3-module-pytest
%endif

BuildArch: noarch
Obsoletes: %oname < 0.999-alt6
Provides: %oname

%add_findreq_skiplist %python_sitelibdir/%oname/_async.py

%description
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
This package contains documentation for %oname.

%package -n python3-module-%oname
Summary: Pexpect is a pure Python Expect. It allows easy control of other applications
Group: Development/Python3

%description -n python3-module-%oname
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%package pickles
Summary: Pickles for Pexpect
Group: Development/Python

%description pickles
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

This package contains pickles for Pexpect.

%prep
%setup
%patch0 -p1

cp -a . ../python3

pushd ../python3
# change shebang python -> python3
find -type f -name '*.py' | \
xargs sed -i '1s|#!/usr/bin/env python[[:space:]]*$|#!/usr/bin/env python3|'

# fix print functions and other for python3
find tests -type f -name '*.py' -exec 2to3 -f print -f imports -w -n '{}' +

# change python -> python3 callings
find tests -type f -name '*.py' | \
	xargs sed -i 's/\(.*pexpect.spawn(\x27python\)\(\(\x27\| \)\)/\13\2/'
sed -i 's|self.runfunc(\x27python exit1.py\x27|self.runfunc(\x27python3 exit1.py\x27|' \
	tests/test_run.py

sed -i '1s|#!/usr/bin/env python[[:space:]]*$|#!/usr/bin/env python3|' \
tests/fakessh/ssh
popd

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install
cp -fR tests %buildroot%python_sitelibdir/pexpect/

pushd ../python3
%python3_install
cp -fR tests %buildroot%python3_sitelibdir/pexpect/
popd

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C doc pickle
%make -C doc html

cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
export LC_ALL="en_US.UTF-8"

py.test -v

pushd ../python3
py.test3 -v
popd

%files
%doc LICENSE *.rst
%python_sitelibdir/pexpect/
%python_sitelibdir/pexpect-*.egg-info/
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%files docs
%doc doc/_build/html
%doc examples

%files pickles
%python_sitelibdir/*/pickle

%files -n python3-module-%oname
%doc LICENSE *.rst
%python3_sitelibdir/pexpect/
%python3_sitelibdir/pexpect-*.egg-info/
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests

%changelog
