%define _unpackaged_files_terminate_build 1

%define oname pyparsing

%def_with python3

Name: python-module-%oname
Version: 2.2.0
Release: alt1

Summary: Python parsing module

License: MIT
Group: Development/Python
URL: https://pypi.org/project/pyparsing
Packager: Python Development Team <python at packages.altlinux.org>
BuildArch: noarch

BuildRequires: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif

# http://prdownloads.sourceforge.net/%oname/%oname-%version.tar.gz
Source: %oname-%version.tar

%description
The parsing module is an alternative approach to creating and executing
simple grammars, vs. the traditional lex/yacc approach, or the use of
regular expressions.  The parsing module provides a library of classes
that client code uses to construct the grammar directly in Python code.

%package -n python3-module-%oname
Summary: Python 3 parsing module
Group: Development/Python3

%description -n python3-module-%oname
The parsing module is an alternative approach to creating and executing
simple grammars, vs. the traditional lex/yacc approach, or the use of
regular expressions.  The parsing module provides a library of classes
that client code uses to construct the grammar directly in Python code.

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc CHANGES examples docs/*
%doc pyparsingClassDiagram.JPG pyparsingClassDiagram.PNG README
%python_sitelibdir/*

%files -n python3-module-%oname
%doc CHANGES examples docs/*
%doc pyparsingClassDiagram.JPG pyparsingClassDiagram.PNG README
%python3_sitelibdir/*

%changelog
