%define modname tablib

Name:		python-module-%modname
Version:	0.12.1
Release:	alt1
Summary:	Format agnostic tabular data library (XLS, JSON, YAML, CSV)

Group:		Development/Python
License:	MIT
URL:		http://github.com/kennethreitz/tablib
Source0:	%name-%version.tar

BuildArch:	noarch

BuildRequires: python-module-chardet python-module-docutils time
BuildRequires: python-module-hacking python-module-html5lib
BuildRequires: python-module-ndg-httpsclient python-module-ntlm python-module-yaml

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-html5lib python3-module-pbr python3-module-yaml


%description
Tablib is a format-agnostic tabular dataset library, written in Python.

Output formats supported:

 - Excel (Sets + Books)
 - JSON (Sets + Books)
 - YAML (Sets + Books)
 - HTML (Sets)
 - TSV (Sets)
 - CSV (Sets)

%package -n python3-module-%modname
Summary:        Format agnostic tabular data library (XLS, JSON, YAML, CSV)
Group:            Development/Python3

%add_python3_req_skip UserDict
%add_python3_req_skip odf

%description -n python3-module-%modname
Tablib is a format-agnostic tabular dataset library, written in Python.

Output formats supported:

 - Excel (Sets + Books)
 - JSON (Sets + Books)
 - YAML (Sets + Books)
 - HTML (Sets)
 - TSV (Sets)
 - CSV (Sets)

%prep
%setup
pushd tablib/packages/dbfpy/
sed -i '/print.*/ s/$/)/' dbfnew.py | sed 's/print/print(/' > dbfnew.py
popd
cp -fR . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%files
%doc README.rst AUTHORS LICENSE
%python_sitelibdir/*

%files -n python3-module-%modname
%doc README.rst AUTHORS LICENSE
%python3_sitelibdir/*


%changelog
