%define oname whoosh
%define fname python-module-%oname
%define descr \
Whoosh is a fast, featureful full-text indexing and searching library \
implemented in pure Python. Programmers can use it to easily add search \
functionality to their applications and websites. Every part of how \
Whoosh works can be extended or replaced to meet your needs exactly.

Name: %fname
Version: 2.7.4
Release: alt1

%if ""==""
Summary: Fast pure-Python indexing and search library
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: BSD
URL: https://bitbucket.org/mchaput/whoosh/wiki/Home
# hg clone https://bitbucket.org/mchaput/whoosh
Source: %oname-%version.tar

BuildRequires(pre): rpm-build-python rpm-macros-sphinx
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv
Buildrequires: python-module-sphinx-pickles python-module-setuptools time

BuildArch: noarch

%if ""=="3"
%add_python3_req_skip google
%add_python3_req_skip google.appengine.api
%add_python3_req_skip google.appengine.ext
%add_python3_req_skip whoosh.automata.fst
%filter_from_provides /^python(whoosh.automata.nfa)/d
# ImportError: No module named 'whoosh.automata.fst'
%filter_from_provides /^python(whoosh.filedb.gae)/d
# ImportError: No module named 'google'
%filter_from_provides /^python(whoosh.support.bench)/d
# ImportError: cannot import name 'find_object'
%endif

%if ""!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
%endif

%description
%descr

%if ""!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for whoosh
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.

%else

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %fname = %version-%release
%if ""=="3"
%py3_requires nose
%endif

%description tests
%descr

This package contains tests for %oname.

%endif

%prep
%setup
%if ""!=""
%prepare_sphinx docs
ln -s ../objects.inv docs/source/
%endif

%build
%if ""==""
%python_build
%else
mkdir docs/source/_static
%generate_pickles docs/source docs/source %oname
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html
%endif

%install
%if ""!=""
mkdir -p %buildroot%python_sitelibdir/%oname/
cp -fR pickle %buildroot%python_sitelibdir/%oname/
%else
%python_install
cp -fR src/whoosh/query src/whoosh/matching %buildroot%python_sitelibdir/%oname/
%endif

%if ""==""
%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/util/testing.py*

%files tests
%doc tests
%python_sitelibdir/%oname/util/testing.py*

%else

%files
%doc html/*

%files -n %fname-pickles
%python_sitelibdir/%oname/pickle
%endif

%changelog
