%define _unpackaged_files_terminate_build 1
%define oname zope.interface

%def_with check

Name: python-module-%oname
Version: 4.6.0
Release: alt1

Summary: Zope interfaces package
License: ZPLv2.1
Group: Development/Python
# Source-git https://github.com/zopefoundation/zope.interface.git
Url: http://www.python.org/pypi/zope.interface

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-module-repoze.sphinx.autointerface
BuildRequires: python-module-setuptools
BuildRequires: python3-module-setuptools
BuildRequires: python-devel
BuildRequires: python3-dev

%if_with check
BuildRequires: python-module-tox
BuildRequires: python-module-zope.event
BuildRequires: python-module-coverage
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.event
BuildRequires: python3-module-coverage
%endif

%description
This is a separate distribution of the %oname package used in
Zope 3, along with the packages it depends on.

%package -n python3-module-%oname
Summary: Zope interfaces package (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
This is a separate distribution of the %oname package used in
Zope 3, along with the packages it depends on.

%package -n python3-module-%oname-tests
Summary: Tests for %oname (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.event

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.event

%description tests
This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
This package contains documentation for %oname.

%prep
%setup
cp -a . ../python3

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

pushd ../python3
%python3_build_debug
popd

%install
%python_install

pushd ../python3
%python3_install
popd

export PYTHONPATH=$PWD/src
%make -C docs pickle
%make -C docs html

install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
export PIP_INDEX_URL=http://host.invalid./
# copy necessary exec deps
tox --sitepackages -e py%{python_version_nodots python} --notest
cp -f %_bindir/coverage .tox/py%{python_version_nodots python}/bin/
tox --sitepackages -e py%{python_version_nodots python} -v -- -v

pushd ../python3
# copy necessary exec deps
tox.py3 --sitepackages -e py%{python_version_nodots python3} --notest
cp -f %_bindir/coverage3 .tox/py%{python_version_nodots python3}/bin/coverage
tox.py3 --sitepackages -e py%{python_version_nodots python3} -v -- -v
popd
 
%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/zope/interface/tests
%exclude %python_sitelibdir/zope/interface/common/tests

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files tests
%python_sitelibdir/zope/interface/tests
%python_sitelibdir/zope/interface/common/tests

%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/zope/interface/tests
%exclude %python3_sitelibdir/zope/interface/common/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/zope/interface/tests
%python3_sitelibdir/zope/interface/common/tests

%changelog
