%define _unpackaged_files_terminate_build 1
%define oname astroid

%def_with check

Name: python3-module-%oname
Version: 2.2.5
Release: alt1

Summary: Python Abstract Syntax Tree New Generation
License: LGPLv2.1+
Group: Development/Python3
# Source-git: https://github.com/PyCQA/astroid.git
Url: https://pypi.org/project/astroid

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest-runner

%if_with check
BuildRequires: python3-module-lazy-object-proxy
BuildRequires: python3-module-nose
BuildRequires: python3-module-pytest
BuildRequires: python3-module-wrapt
BuildRequires: python3-module-numpy
BuildRequires: python3-module-typed_ast
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-tox
%endif

BuildArch: noarch
%py3_requires typed_ast

%description
The aim of this module is to provide a common base representation of python
source code. It is currently the powering pylint's capabilities.

It provides a compatible representation which comes from the _ast module. It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast. The new node classes have additional
methods and attributes for different usages. They include some support for
static inference and local name scopes. Furthermore, astroid can also build
partial trees by inspecting living objects.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
grep -qs '[[:space:]]*attr[[:space:]]*$' tox.ini || exit 1
grep -qs '[[:space:]]*coverage[[:space:]]*$' tox.ini || exit 1
grep -qs ' {envsitepackagesdir}/coverage run ' tox.ini || exit 1
grep -qsF 'py36: typed_ast<1.3.0' tox.ini || exit 1

sed -i '/[[:space:]]*attr[[:space:]]*$/d' tox.ini
sed -i '/[[:space:]]*coverage[[:space:]]*$/d' tox.ini
sed -i 's/ {envsitepackagesdir}\/coverage run / /' tox.ini
sed -i 's/py36: typed_ast<1\.3\.0/py36: typed_ast>=1.3.0/' tox.ini

export PIP_NO_INDEX=YES
export PIP_NO_DEPS=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc ChangeLog README.rst
%python3_sitelibdir/astroid/
%python3_sitelibdir/astroid-*.egg-info/

%changelog
