%define _unpackaged_files_terminate_build 1
%define oname zope.i18nmessageid
%define fname python3-module-%oname
%define descr \
This package provides facilities for *declaring* messages within \
program source text;  translation of the messages is the responsiblity \
of the 'zope.i18n' package.

%def_with check

Name: %fname-docs
Version: 4.3.1
Release: alt1

%if "-docs"==""
Summary: Message Identifiers for internationalization
Group: Development/Python3
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: ZPLv2.1
# Source-git https://github.com/zopefoundation/zope.i18nmessageid.git
Url: http://pypi.python.org/pypi/zope.i18nmessageid
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx rpm-build-python3
BuildRequires: python3-dev python-module-sphinx python3-module-sphinx-devel python3-module-setuptools

%if_with check
BuildRequires: python3-module-zope.testing python3-module-zope.testrunner
%endif

%if "-docs"!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
BuildArch: noarch
%endif

%description
%descr

%if "-docs"!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for Zope Configuration Markup Language (ZCML)
Group: Development/Python3

%description -n %fname-pickles
%descr

This package contains pickles for %oname.

%else

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
%descr

This package contains tests for %oname.

%endif

%prep
%setup
%if "-docs"!=""
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%if "-docs"==""
%add_optflags -fno-strict-aliasing
%python3_build
%else
%make -C docs pickle
%make -C docs html
%endif

%install
%if "-docs"==""
%python3_install
%else
install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%if "-docs"==""
%check
export PYTHONPATH=src
python3 setup.py test -v

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/zope/i18nmessageid/tests.*

%files tests
%python3_sitelibdir/zope/i18nmessageid/tests.*

%else

%files
%doc docs/_build/html

%files -n %fname-pickles
%python3_sitelibdir/*/pickle
%endif

%changelog
