%define _unpackaged_files_terminate_build 1

Name: sway
Version: 1.4
Release: alt1.1.p9
Epoch:   1
Summary: i3wm drop-in replacement for Wayland
License: MIT
Url: http://swaywm.org/
Group: Graphical desktop/Other

# https://github.com/swaywm/sway
# git://git.altlinux.org/gears/s/sway.git
Source0: %name-%version.tar
Source1: startsway
Source2: Sway_Wallpaper_Gray.png

Patch00: sway-config.patch

BuildRequires: gcc-c++
BuildRequires: asciidoc-a2x
BuildRequires: cmake
BuildRequires: libcap-devel
BuildRequires: libdbus-devel
BuildRequires: libevdev-devel
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libjson-c-devel
BuildRequires: libpam-devel
BuildRequires: libpango-devel
BuildRequires: libpcre-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwlc0-devel
BuildRequires: libwlc-devel >= 0.0.10
BuildRequires: libwlroots-devel >= 0.10.1-alt2
BuildRequires: libGLES-devel
BuildRequires: meson
BuildRequires: scdoc
BuildRequires: time

# swaybg is now distributed as a standalone program which is compatible with many Wayland compositors (sway 1.1-rc1)
Requires: swaybg

# swayidle, a new idle management daemon, is available separately (sway 1.0)
Requires: swayidle

Requires: dmenu-wl
Requires: %name-data

%description
Sway is a drop-in replacement for the i3 window manager, but for Wayland
instead of X11. It works with your existing i3 configuration and
supports most of i3's features, and a few extras.

%package data
Summary: i3wm drop-in replacement for Wayland - data files
Group: Graphical desktop/Other
BuildArch: noarch

%description data
This package contains data files.

%prep
%setup
%patch00 -p2

%build
%meson \
	-Dwerror=false \
	#
%meson_build

%install
%meson_install

mkdir -p %buildroot/%_sysconfdir/%name/config.d

install -p -m0755 -D %SOURCE1 %buildroot/%_bindir/
install -p -m0644 -D %SOURCE2 %buildroot/%_datadir/backgrounds/%name/

rm -rf -- \
	%buildroot/%_datadir/bash-completion \
	%buildroot/%_datadir/fish \
	%buildroot/%_datadir/zsh \
	#

%files
%doc LICENSE
%doc README.md
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/config.d
%dir %_sysconfdir/%name/security.d
%config(noreplace) %_sysconfdir/%name/config
%config(noreplace) %_sysconfdir/%name/security.d/00-defaults
%_bindir/sway
%_bindir/startsway
%_bindir/swaybar
%_bindir/swaymsg
%_bindir/swaynag
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_datadir/wayland-sessions/sway.desktop

%files data
%dir %_datadir/backgrounds/%name
%_datadir/backgrounds/%name/*

%changelog
