Name: sylpheed
Version: 3.7.0
Release: alt0.4

Summary: a GTK+ based, lightweight, and fast e-mail client
License: GPLv2+
Group: Networking/Mail
URL: http://sylpheed.sraoss.jp/en/
Packager: Ilya Mashkin <oddity@altlinux.ru>

%def_enable ldap
%def_disable jpilot
%def_enable gtkspell

Source: %name-%version.tar.bz2

Source1: %{name}_icons.tar
Source5: %name-README.actions

Patch0: %name-0.6.4-colorder.patch
Patch1: %name-2.2.4-alt-mboxlock.patch
Patch2: %name-0.9.1-alt-nullpass.patch
Patch3: %name-2.2.4-alt-nntperr.patch
Patch4: %name-0.8.5-alt-ldapcriteria.patch
Patch5: %name-2.2.4-alt-noincludedir.patch
Patch6: %name-2.2.4-alt-qpfix.patch
Patch7: %name-2.2.4-alt-quoteformat-default.patch
Patch8: %name-2.2.4-alt-passphrase-grab.patch
Patch9: %name-2.2.4-alt-jpilotcharset.patch
Patch10: %name-2.2.5-alt-final_newline_fix.patch
Patch11: %name-2.2.5-alt-gtkspell-enchant.patch

Patch21: %name-3.1.0-alt-desktop.patch
Patch22: %name-3.1.0-alt-icons.patch
Patch23: %name-3.1.2-alt-glib2-2.32.0.patch
Patch24: %name-3.6.0-alt-certdir.patch
Patch25: %name-3.7.0-tofu.patch

# old patches - not applied, should be obsolete now
Patch1000: %name-0.9.3cvs9-alt-wm_race.patch

Requires: mailcap
Requires: libgpgme >= 1.7.0

%{?_enable_ldap:BuildPreReq: libldap-devel}
%{?_enable_jpilot:BuildPreReq: libpilot-link-devel}
%{?_enable_gtkspell:BuildPreReq: libenchant-devel libgtkspell-devel}

# Automatically added by buildreq on Mon May 29 2006,
# then manually edited to remove libldap-devel and libpilot-link-devel
# (conditional dependencies) and other crap
BuildRequires: flex fontconfig glib2-devel libatk-devel libcompface-devel libgpg-error-devel libgpgme-devel libgtk+2-devel libpango-devel libssl-devel pkg-config

#BuildRequires: libdbus-glib-devel

%description
Sylpheed is an e-mail client (and news reader) based on GTK+, running on
X Window System, and aiming for
 * Quick response
 * Graceful, and sophisticated interface
 * Easy configuration, intuitive operation
 * Abundant features
The appearance and interface are similar to some popular e-mail clients
for Windows, such as Outlook Express, Becky!, and Datula. The interface
is also designed to emulate the mailers on Emacsen, and almost all
commands are accessible with the keyboard.

The messages are managed by MH format, and you will be able to use it
together with another mailer based on MH format (like Mew). You can
also utilize fetchmail or/and procmail, and external programs on
receiving (like inc or imget).
%if_enabled ldap
This version of Sylpheed is built with LDAP support, so you can get
address book information from a LDAP server.
%endif #enabled ldap
%if_enabled jpilot
This version of Sylpheed includes pilot-link support, so you can use the
address book from your Pilot in Sylpheed.
%endif #enabled jpilot

%package devel
Summary: Development files for sylpheed
Group: Development/Other
Requires: sylpheed = %version-%release

%description devel
Sylpheed - lightweight and user-friendly e-mail client.

This package contains development files.


%prep
%setup -a1
#patch0 -p0
#patch1 -p1
#patch2 -p1
#patch3 -p1
#patch4 -p1
#patch5 -p1
#patch6 -p1
#patch7 -p1
#patch8 -p1
#patch9 -p1
#patch10 -p1
#patch11 -p1

#patch21 -p2
%patch22 -p2
#patch23 -p2
%patch24 -p2
%patch25 -p1

cp -a %SOURCE5 README.actions
bzip2 -9fk ChangeLog

%build
#rm -f missing
aclocal -I ac
libtoolize --force --copy
autoheader
automake --gnu --add-missing --copy
autoconf

# --disable-shared is for noinst_LTLIBRARIES = libsylph.la
%configure \
	--enable-gpgme \
	--enable-ssl \
	--enable-fcntl \
	--enable-flock \
	--disable-shared \
	%{subst_enable ldap} \
	%{subst_enable jpilot} \
	%{subst_enable gtkspell}

%make_build

%install
%makeinstall_std
#install -pD -m644 %{name}_16.xpm $RPM_BUILD_ROOT%_miconsdir/%name.xpm
#install -pD -m644 %{name}_32.xpm $RPM_BUILD_ROOT%_niconsdir/%name.xpm

%find_lang %name


%files -f %name.lang
%_bindir/%name
%_datadir/%name
%_desktopdir/%name.desktop
#_miconsdir/%name.xpm
#_niconsdir/%name.xpm
%_liconsdir/%name.png
%_iconsdir/hicolor/64x64/apps/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%doc COPYING AUTHORS ChangeLog.bz2 NEWS README TODO README.actions

%files devel
%doc PLUGIN.txt
%_includedir/sylpheed/

%changelog
