%def_with python3
%def_with doc

Name: sympy
Version: 1.1.1
Release: alt1.1.1
Epoch: 1

Summary: A Python library for symbolic mathematics
License: New BSD License
Group: Sciences/Mathematics

Url: http://sympy.org/
# https://github.com/sympy/sympy.git
Source: %name-%version.tar
Patch1: %name-%version-alt-build.patch

BuildArch: noarch

Requires: python-module-%name = %EVR

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-py python-module-setuptools
BuildRequires: python-module-numpy python-module-mpmath
BuildRequires: dvipng ImageMagick-tools graphviz librsvg-utils
%if_with doc
BuildRequires: python-module-sphinx-devel
BuildRequires: python-module-docutils
BuildRequires: python-module-Pygments
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-py python-tools-2to3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-mpmath
%endif

%add_python3_req_skip py.__.test.item py.__.test.terminal.terminal

%description
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%if_with python3
%package py3
Summary: A Python 3 library for symbolic mathematics
Group: Development/Python3
Requires: python3-module-%name = %EVR

%description py3
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%package -n python3-module-%name
Summary: A Python 3 module for symbolic mathematics
Group: Development/Python3
Requires: python3-module-%name-tests = %EVR
%add_python3_req_skip primetest pytest runtests

%description -n python3-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python3-module-%name-tests
Summary: Tests for SymPy (Python 3)
Group: Development/Python3
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-tests
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains tests for SymPy.
%endif

%package -n python-module-%name
Summary: A Python module for symbolic mathematics
Group: Development/Python
Requires: python-module-%name-tests = %EVR
%add_python_req_skip primetest pytest runtests
%setup_python_module %name

%description -n python-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python-module-%name-examples
Summary: Examples for SymPy
Group: Development/Documentation
Requires: python-module-%name = %EVR

%description -n python-module-%name-examples
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains examples for SymPy.

%package -n python-module-%name-tests
Summary: Tests for SymPy
Group: Development/Python
Requires: python-module-%name = %EVR

%description -n python-module-%name-tests
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains tests for SymPy.

%package -n python-module-%name-pickles
Summary: Pickles for SymPy
Group: Development/Python

%description -n python-module-%name-pickles
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains pickles for SymPy.

%package -n python-module-%name-doc
Summary: Documentation for SymPy
Group: Development/Documentation
BuildArch: noarch

%description -n python-module-%name-doc
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains development documentation for SymPy.

%prep
%setup
%patch1 -p1

for i in $(find ./ -name tests); do
	touch $i/__init__.py
done

sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
%if_with doc
%prepare_sphinx .
%endif

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%if_with doc
pushd doc
%make html
popd

rm -fR doctrees
cp -fR doc/_build/doctrees doc/src/
export PYTHONPATH=$PYTHONPATH:$PWD
cp -fR doc/_build/doctrees ./

%generate_pickles $PWD $PWD/doc/_build/html %name
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd

pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd

pushd %buildroot%_man1dir
for i in $(ls); do
	mv $i py3_$i
done
popd
%endif

%python_install

rm -f %buildroot%python_sitelibdir/%name/mpmath/libmp/exec_py3.py
rm -f %buildroot%python3_sitelibdir/%name/mpmath/libmp/exec_py2.py

%if_with doc
cp -fR pickle %buildroot%python_sitelibdir/%name/
%endif

%check
#python setup.py test -v
#python bin/test -v
%if_with doc
python bin/doctest -v ||:
%endif

%if_with python3
pushd ../python3
#python3 setup.py test -v
#python3 bin/test -v
%if_with doc
python3 bin/doctest -v ||:
%endif
popd
%endif

%files
%doc AUTHORS LICENSE README*
%_bindir/*
%_man1dir/*
%if_with python3
%exclude %_bindir/py3_*
%exclude %_man1dir/py3_*
%endif

%files -n python-module-%name
%python_sitelibdir/*
%exclude %python_sitelibdir/*/*test*
%exclude %python_sitelibdir/*/*/*test*
%exclude %python_sitelibdir/*/*/*/*test*
%if_with doc
%exclude %python_sitelibdir/%name/pickle

%files -n python-module-%name-pickles
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/pickle
%endif

%files -n python-module-%name-tests
%python_sitelibdir/*/*test*
%python_sitelibdir/*/*/*test*
%python_sitelibdir/*/*/*/*test*

%files -n python-module-%name-examples
%doc examples/*

%if_with doc
%files -n python-module-%name-doc
%doc doc/_build/html/*
%endif

%if_with python3
%files py3
%doc AUTHORS LICENSE README*
%_bindir/py3_*
%_man1dir/py3_*

%files -n python3-module-%name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/*test*
%exclude %python3_sitelibdir/*/*/*test*
%exclude %python3_sitelibdir/*/*/*/*test*
%exclude %python3_sitelibdir/*/*/*/*/*test*

%files -n python3-module-%name-tests
%python3_sitelibdir/*/*test*
%python3_sitelibdir/*/*/*test*
%python3_sitelibdir/*/*/*/*test*
%python3_sitelibdir/*/*/*/*/*test*
%endif

%changelog
