Name: sysklogd
Version: 1.8.0
Release: alt1

%define ROOT %_localstatedir/klogd

Summary: Base package for system logging and kernel message trapping daemons
License: GPLv2+
Group: System/Kernel and hardware
Url: https://github.com/legionus/sysklogd/
Packager: Alexey Gladkov <legion@altlinux.ru>

Source0: %name-%version.tar

Requires(pre): syslogd = %version-%release
Requires(pre): klogd   = %version-%release

%description
This virtual package contains dependencies on syslogd and klogd.

%package -n syslogd
Summary: System logging daemon (syslogd)
Group: System/Kernel and hardware
Provides: syslogd-daemon
Requires(pre): syslog-common

%description -n syslogd
This package contains syslogd wich provide support for system logging.
syslogd runs as daemon (background process) and logs system messages to
different places according to a configuration file.

%package -n klogd
Summary: Kernel message trapping daemon (klogd)
Group: System/Kernel and hardware
Requires(pre): syslogd-daemon

%description -n klogd
This package contains klogd wich provide support for kernel logging.
klogd runs as daemon (background process) and logs kernel messages
via system logger.

%prep
%setup -q

%build
%autoreconf -fi
%configure --sbindir=/sbin
%make_build

%install
mkdir -p %buildroot{%_mandir/man{5,8},/sbin}

%makeinstall_std

install -pD -m640 altlinux/syslog.conf       %buildroot%_sysconfdir/syslog.conf
install -pD -m755 altlinux/syslogd.init      %buildroot%_initdir/syslogd
install -pD -m640 altlinux/syslogd.sysconfig %buildroot%_sysconfdir/sysconfig/syslogd
install -pD -m755 altlinux/klogd.init        %buildroot%_initdir/klogd
install -pD -m640 altlinux/klogd.sysconfig   %buildroot%_sysconfdir/sysconfig/klogd

chmod 755 %buildroot/sbin/*

mkdir -m700 %buildroot%_sysconfdir/syslog.d
ln -s %ROOT/dev/log %buildroot%_sysconfdir/syslog.d/klogd

# chroot stuff
mkdir -p %buildroot/%ROOT/dev
mksock %buildroot%ROOT/dev/log

%triggerpostun -- %name <= 1.4.1-alt3
if [ $1 -gt 1 ]; then
	if pidof /sbin/klogd >/dev/null; then
		/sbin/service klogd restart ||:
	fi
	if pidof /sbin/syslogd >/dev/null; then
		/sbin/service syslogd restart ||:
	fi
fi

%triggerin -n syslogd -- syslogd <= 1.4.1-alt30
if [ -s "%_sysconfdir/sysconfig/syslogd" ]; then
	. "%_sysconfdir/sysconfig/syslogd"
	set -- ${SYSLOGD_OPTIONS-}
	found=
	OPTS=
	for a; do
		if [ "$a" = '-A' ]; then
			OPTS="${OPTS:+$OPTS }-P"
			found=1
		else
			OPTS="${OPTS:+$OPTS }$a"
		fi
	done
	if [ -n "$found" ]; then
		sed -i \
			-e "s#^SYSLOGD_OPTIONS=.*#SYSLOGD_OPTIONS='$OPTS'#" \
			"%_sysconfdir/sysconfig/syslogd"
		echo >&2 "WARNING: The '-A' option has been renamed to '-P'"
		echo >&2 "in the '%_sysconfdir/sysconfig/syslogd'."
		echo >&2 "Verify that the configuration is correct."
	fi
fi

%pre -n syslogd
/usr/sbin/groupadd -r -f syslogd
/usr/sbin/useradd -r -g syslogd -d /dev/null -s /dev/null -n syslogd >/dev/null 2>&1 ||:

%post -n syslogd
%post_service syslogd

%preun -n syslogd
%preun_service syslogd

%pre -n klogd
/usr/sbin/groupadd -r -f klogd
/usr/sbin/useradd -r -g klogd -d /dev/null -s /dev/null -n klogd >/dev/null 2>&1 ||:

%post -n klogd
%post_service klogd

%preun -n klogd
%preun_service klogd

%files

%files -n klogd
%config %_initdir/klogd
%config(noreplace) %_sysconfdir/sysconfig/klogd
%_sysconfdir/syslog.d/klogd
/sbin/klogd
%_mandir/man?/klogd*
%attr(710,root,klogd) %dir %ROOT
%attr(710,root,klogd) %dir %ROOT/dev
%attr(666,root,root) %ghost %ROOT/dev/log

%files -n syslogd
%config(noreplace) %attr(640,root,adm) %_sysconfdir/syslog.conf
%config(noreplace) %_sysconfdir/sysconfig/syslogd
%config %_initdir/syslogd
/sbin/syslog*
%_mandir/man?/sys*
%doc README* NEWS

%changelog
