Name: u-boot-meson
Version: 2021.01
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: aarch64

Source: %name-%version-%release.tar

BuildRequires: bc dtc >= 1.4 flex

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various AMLogic Meson family boards.

%prep
%setup

%build
boards=$(grep -lr ARCH_MESON configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do
	mkdir build
	%make_build O=build ${board}_defconfig all
	install -pm0644 -D build/u-boot.bin out/${board}/u-boot.bin
	rm -rf build
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README doc/board/amlogic/*
%_datadir/u-boot/*

%changelog
