
Name: virt-viewer
Version: 9.0
Release: alt1

Summary: Virtual Machine Viewer
Group: System/Configuration/Other
License: GPL-2.0+
Url: https://gitlab.com/virt-viewer/virt-viewer
# Vcs https://gitlab.com/virt-viewer/virt-viewer
Source: %name-%version.tar

Obsoletes: spice-client < 0.12.5-alt3

BuildRequires: glib2-devel >= 2.40 libgio-devel
BuildRequires: libxml2-devel
BuildRequires: libvirt-devel >= 0.9.7 libvirt-glib-devel >= 0.1.8
BuildRequires: libgtk+3-devel >= 3.12
BuildRequires: perl-podlators gettext
BuildRequires: libspice-gtk3-devel >= 0.35 libspice-glib-devel spice-protocol >= 0.12.7
BuildRequires: libgtk3vnc-devel >= 0.4.0
BuildRequires: libvte3-devel
BuildRequires: libgovirt-devel >= 0.3.3 librest-devel >= 0.8
BuildRequires: bash-completion

%description
Virt Viewer provides a graphical viewer for the guest OS
display. At this time is supports guest OS using the VNC
or SPICE protocols. Further protocols may be supported in
the future as user demand dicatates. The viewer can connect
directly to both local and remotely hosted guest OS, optionally
using SSL/TLS encryption.

%prep
%setup

%build
mkdir -p m4
touch ChangeLog AUTHORS
%autoreconf
%configure \
	--disable-static \
	--disable-update-mimedb \
    --with-spice-gtk \
    --with-vte \
	--with-buildid=-%release

%make_build

%install
%make_install install  DESTDIR=%buildroot
%find_lang %name

%files -f %name.lang
%doc README.md COPYING NEWS
%_bindir/*
%_man1dir/*
%_datadir/mime/packages/*.xml
%_desktopdir/*.desktop
%_datadir/appdata/remote-viewer.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_iconsdir/hicolor/*/devices/*
%_datadir/bash-completion/completions/virt-viewer

%changelog
