%define _unpackaged_files_terminate_build 1
%def_disable static
%define gecko_version 2.47.2
%define mono_version 6.3.0

%define major 6.14
%define rel %nil
%define stagingrel %nil

%def_with gtk3

%ifarch %{ix86}
%define winepedir i386-windows
%define winesodir i386-unix
%endif
%ifarch x86_64
%define winepedir x86_64-windows
%define winesodir x86_64-unix
%endif
%ifarch %{arm}
%define winepedir arm-windows
%define winesodir arm-unix
%endif
%ifarch aarch64
%define winepedir aarch64-windows
%define winesodir aarch64-unix
%endif

# rpm-build-info gives _distro_version
%if %_vendor == "alt" && (%_distro_version == "p9" || %_distro_version == "Sisyphus")
%def_with vulkan
# vkd3d depends on vulkan
%def_with vkd3d
%def_with faudio
%endif

%def_with opencl

Name: wine
Version: %major.1
Release: alt1
Epoch: 1

Summary: WINE Is Not An Emulator - environment for running Windows applications

License: LGPLv2+
Group: Emulators
Url: https://www.altlinux.org/Wine

Packager: Vitaly Lipatov <lav@altlinux.ru>

# TODO: major in gear

# Source-url: https://dl.winehq.org/wine/source/6.x/wine-%major%rel.tar.xz
Source: %name-%version.tar
# Source1-url: https://github.com/wine-staging/wine-staging/archive/v%major%stagingrel.tar.gz
Source1: %name-staging-%version.tar

Source3: %name-%version-desktop.tar
Source4: %name-%version-icons.tar
Source6: %name-%version-scripts.tar

# local patches
Source10: %name-patches-%version.tar

AutoReq: yes, noperl

ExclusiveArch: %ix86 x86_64 aarch64

# try build wine64 only on ALT
%if %_vendor == "alt"
%ifarch x86_64 aarch64
    %def_with build64
    %define winearch wine64
%else
    %def_without build64
    %define winearch wine32
    # skip -fPIC checking (-fnoPIC need in new wine to skip DECLSPEC_HOTPATCH)
    %add_verify_elf_skiplist %_libdir/wine/*.so
    # TODO: use -fPIC for libwine.so.1
    %add_verify_elf_skiplist %_libdir/*.so.*
    # -fPIC is totally disabled for i586
    %add_verify_elf_skiplist %_bindir/*
%endif
%else
   %def_without build64
   %define winearch wine32
%endif

# TODO:
%define libdir %_libdir
%define libwinedir %libdir/wine

# for wine-staging gitapply.sh script
BuildPreReq: /proc

%ifarch aarch64
BuildRequires: clang >= 5.0
%else
BuildRequires: gcc
%endif

# General dependencies
BuildRequires(pre): rpm-build-intro >= 2.1.14
BuildRequires: util-linux flex bison
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: zlib-devel libldap-devel libgnutls-devel
BuildRequires: libxslt-devel libxml2-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libtiff-devel
BuildRequires: libgphoto2-devel libsane-devel libcups-devel
BuildRequires: libalsa-devel jackit-devel libgsm-devel libmpg123-devel libpulseaudio-devel
BuildRequires: libopenal-devel libGLU-devel
BuildRequires: libusb-devel libieee1284-devel libkrb5-devel
BuildRequires: libv4l-devel
BuildRequires: libunixODBC-devel
BuildRequires: libpcap-devel
BuildRequires: libnetapi-devel
#BuildRequires: gstreamer-devel gst-plugins-devel
# TODO: osmesa

%if_with vulkan
BuildRequires: libvulkan-devel
%endif
%if_with vkd3d
BuildRequires: vkd3d-devel >= 1.2
%endif
%if_with faudio
BuildRequires: libfaudio-devel
%endif

%if_with opencl
BuildRequires: ocl-icd-devel opencl-headers
%endif

# Staging part
%if_with gtk3
# GTK3 theme support: staging only
BuildRequires: libgtk+3-devel libcairo-devel
%endif
BuildRequires: libva-devel

# udev needed for udev version detect
BuildRequires: libudev-devel udev libdbus-devel

BuildRequires: libxcb-devel
BuildRequires: libICE-devel libSM-devel
BuildRequires: libX11-devel libXau-devel libXaw-devel libXrandr-devel
BuildRequires: libXext-devel libXfixes-devel libXfont-devel libXft-devel libXi-devel
BuildRequires: libXmu-devel libXpm-devel libXrender-devel
BuildRequires: libXres-devel libXScrnSaver-devel libXinerama-devel libXt-devel
BuildRequires: libXxf86dga-devel libXxf86misc-devel libXcomposite-devel
BuildRequires: libXxf86vm-devel libfontenc-devel libXdamage-devel
BuildRequires: libXvMC-devel libXcursor-devel libXevie-devel libXv-devel

BuildRequires: perl-XML-Simple

# Actually for x86_32
Requires: glibc-pthread glibc-nss


Requires: webclient

Requires: wine-gecko = %gecko_version
Conflicts: wine-mono < %mono_version

BuildRequires: desktop-file-utils
# Use it instead proprietary MS Core Fonts
# Requires: fonts-ttf-liberation

# For menu/MIME subsystem
Requires: desktop-file-utils

Requires: lib%name = %EVR

Conflicts: wine-vanilla wine-etersoft

Requires: cabextract

# Provides/Obsoletes Fedora packages
%define common_provobs wine-filesystem wine-desktop wine-systemd wine-sysvinit
%define base_provobs wine-alsa wine-capi wine-cms wine-ldap wine-openal wine-pulseaudio wine-wow wine-alsa wine-capi wine-cms wine-ldap wine-openal wine-opencl wine-pulseaudio wine-twain
%define fonts_provobs wine-fonts wine-arial-fonts wine-courier-fonts wine-fixedsys-fonts wine-marlett-fonts wine-ms-sans-serif-fonts wine-small-fonts wine-symbol-fonts wine-system-fonts wine-tahoma-fonts wine-times-new-roman-fonts wine-wingdings-fonts
#Provides: %common_provobs %base_provobs %fonts_provobs
Obsoletes: %common_provobs %base_provobs %fonts_provobs

#BuildRequires(pre): rpm-macros-wine

#=========================================================================

%description
Wine (originally an acronym for "Wine Is Not an Emulator")
is a compatibility layer capable of running Windows applications.
Instead of simulating internal Windows logic like a virtual machine or emulator,
Wine translates Windows API calls into POSIX calls on-the-fly,
eliminating the performance and memory penalties
of other methods and allowing you to cleanly integrate Windows applications into your desktop.

This build based on wine source with wine-staging project patches
and ALT in progress patches.

%package test
Summary: WinAPI test for Wine
Summary(ru_RU.UTF-8): Тест WinAPI для Wine
Group: Emulators
Requires: %name = %EVR
Conflicts: wine-vanilla-test

%description test
WinAPI test for Wine (unneeded for usual work).
Warning: it may kill your X server suddenly.

%package full
Summary: Wine meta package
Summary(ru_RU.UTF-8): Мета пакет Wine
Group: Emulators
# due ExclusiveArch
#BuildArch: noarch
Requires: %name = %EVR
Requires: %name-programs = %EVR
Requires: lib%name-gl = %EVR

Requires: wine-mono = %mono_version
Requires: wine-gecko = %gecko_version
Requires: winetricks

Conflicts: wine-vanilla-full


%description full
Wine meta package. Use it for install all wine subpackages.

%package programs
Summary: Wine programs
Group: Emulators
Requires: %name = %EVR
# due ExclusiveArch
#BuildArch: noarch

Conflicts: wine-vanilla-programs

%description programs
Wine GUI programs:
 * winefile
 * notepad
 * winemine

%package -n lib%name
Summary: Main library for Wine
Group: System/Libraries
Conflicts: libwine-vanilla

# Actually for x86_32
Requires: glibc-nss

# Runtime linked
Requires: libcups
Requires: libXrender libXi libXext libX11 libICE
Requires: libXcomposite libXcursor libXinerama libXrandr
Requires: libssl libgnutls30
Requires: libpng16 libjpeg libtiff5
Requires: libxslt

%if_with gtk3
Requires: libcairo libgtk+3
%endif

%if_with vulkan
Requires: libvulkan1
%endif

# Recommended
#Requires: libnetapi libunixODBC2 libpcap0.8

# Linked:
#Requires: fontconfig libfreetype

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with Wine.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет состоит из библиотек, которые реализуют Windows API.


%package -n lib%name-gl
Summary: DirectX/OpenGL support libraries for Wine
Group: System/Libraries
Requires: lib%name = %EVR
Conflicts: libwine-vanilla-gl

# Runtime linked (via dl_open)
Requires: libGL

# wine-staging only
Requires: libva
Requires: libtxc_dxtn

%description -n lib%name-gl
This package contains the libraries for DirectX/OpenGL support in Wine.

%package -n lib%name-twain
Summary: Twain support library for Wine
Group: System/Libraries
Requires: lib%name = %EVR
Conflicts: libwine-vanilla-twain

# Runtime linked (via dl_open)
Requires: libsane

%description -n lib%name-twain
This package contains the library for Twain support.


%package -n lib%name-devel
Summary: Headers for lib%name-devel
Group: Development/C
Requires: lib%name = %EVR
Obsoletes: wine-devel
Provides: wine-devel
Conflicts: libwine-vanilla-devel

# due winegcc require
Requires: gcc-c++

%description -n lib%name-devel
lib%name-devel contains the header files and some utilities needed to
develop programs using lib%name.

%description -n lib%name-devel -l ru_RU.UTF-8
lib%name-devel содержит файлы для разработки программ, использующих Wine:
заголовочные файлы и утилиты, предназначенные
для компилирования программ с lib%name.

%package -n lib%name-devel-static
Summary: Static libraries for lib%name
Group: Development/C
Requires: lib%name = %EVR
Conflicts: libwine-vanilla-devel-static

%description -n lib%name-devel-static
lib%name-devel-static contains the static libraries needed to
develop programs which make use of Wine.


%prep
%setup -a 1 -a 10
# Apply wine-staging patches
%name-staging/patches/patchinstall.sh DESTDIR=$(pwd) --all --backend=patch

# disable rpath using for executable
%__subst "s|^\(LDRPATH_INSTALL =\).*|\1|" Makefile.in

# Apply local patches
%name-patches/patchapply.sh

%build
%ifarch aarch64
%remove_optflags -frecord-gcc-switches
export CC=clang
%endif

%configure --with-x \
%if_with build64
	--enable-win64 \
%endif
	--disable-tests \
	%{subst_enable static} \
	%{subst_with gtk3} \
	--without-gstreamer \
	--without-oss \
	--without-capi \
	--without-hal \
	--without-mingw \
	--with-xattr \
	%{subst_with vulkan} \
	%{subst_with vkd3d} \
	%{subst_with faudio} \
	%nil

%__make depend
%make_build


%install
%makeinstall_std

mv -v %buildroot%libwinedir/%winesodir/libwine.so.1* %buildroot%libdir

install tools/wineapploader %buildroot%_bindir/wineapploader

# unpack desktop files
cd %buildroot%_desktopdir/
tar xvf %SOURCE3
mkdir -p %buildroot%_datadir/desktop-directories/
mv *.directory %buildroot%_datadir/desktop-directories/

# unpack icons files
mkdir -p %buildroot%_iconsdir/
cd %buildroot%_iconsdir/
tar xvf %SOURCE4

# unpack scripts files
mkdir -p %buildroot%_bindir/
cd %buildroot%_bindir/
tar xvf %SOURCE6

# Do not pack non english man pages yet
rm -rf %buildroot%_mandir/*.UTF-8

# Do not pack dangerous association for run windows executables
rm -f %buildroot%_desktopdir/wine.desktop

%if_disabled static
for i in %buildroot%libwinedir/%winesodir/*.a ; do
    [ "$i" == "%buildroot%libwinedir/%winesodir/libwinecrt0.a" ] && continue
    rm -fv $i
done
%endif

%files
%doc ANNOUNCE AUTHORS LICENSE README
%lang(de) %doc documentation/README.de
%lang(es) %doc documentation/README.es
%lang(fr) %doc documentation/README.fr
%lang(hu) %doc documentation/README.hu
%lang(it) %doc documentation/README.it
%lang(ko) %doc documentation/README.ko
%lang(nb) %doc documentation/README.no
%lang(pt) %doc documentation/README.pt
%lang(pt_BR) %doc documentation/README.pt_br
%lang(tr) %doc documentation/README.tr

%_bindir/wine_setup

%if_without build64
%_bindir/wine
%_bindir/wine-preloader
%else
%_bindir/wine64
%_bindir/wine64-preloader
%endif
%_bindir/wineapploader

%_bindir/regsvr32
%_bindir/winecfg
%_bindir/regedit
%_bindir/msiexec

%_bindir/wineconsole
%_bindir/wineserver

%_bindir/winedbg
%_bindir/wineboot
%_bindir/winepath
%libwinedir/%winesodir/*.exe.so

#%_initdir/wine
#%_initdir/wine.outformat

%_iconsdir/*

%_desktopdir/wine-mime-msi.desktop
%_desktopdir/wine-regedit.desktop
#_desktopdir/wine-serverkill.desktop
%_desktopdir/wine-uninstaller.desktop
%_desktopdir/wine-winecfg.desktop
%_desktopdir/wine-wineconsole.desktop
#_desktopdir/wine-winehelp.desktop

# danger
#_desktopdir/wine.desktop

%_datadir/desktop-directories/*.directory

%if_without build64
%_man1dir/wine.*
%endif
%_man1dir/msiexec.*
%_man1dir/regedit.*
%_man1dir/regsvr32.*
%_man1dir/wineboot.*
%_man1dir/winecfg.*
%_man1dir/wineconsole.*
%_man1dir/winepath.*
%_man1dir/wineserver.*
%_man1dir/winedbg.*

%files -n lib%name
%doc LICENSE AUTHORS COPYING.LIB
# for compatibility only
%libdir/libwine.so.1
%libdir/libwine.so.1.0
%dir %libwinedir/
%dir %libwinedir/%winesodir/
%dir %libwinedir/%winepedir/

%if_without build64
%libwinedir/%winesodir/*.dll16.so
%libwinedir/%winesodir/*.drv16.so
%libwinedir/%winesodir/*.exe16.so
%libwinedir/%winesodir/winoldap.mod16.so
%libwinedir/%winesodir/*.vxd.so
%endif

%libwinedir/%winesodir/ntdll.so
%libwinedir/%winesodir/dnsapi.so
%libwinedir/%winesodir/dwrite.so
%libwinedir/%winesodir/gdi32.so
%libwinedir/%winesodir/user32.so
%libwinedir/%winesodir/bcrypt.so
%libwinedir/%winesodir/qcap.so
%libwinedir/%winesodir/odbc32.so
%libwinedir/%winesodir/windowscodecs.so
%libwinedir/%winesodir/windows.networking.connectivity.so
%libwinedir/%winesodir/crypt32.so
%libwinedir/%winesodir/kerberos.so
%libwinedir/%winesodir/light.msstyles.so
%libwinedir/%winesodir/netapi32.so
%libwinedir/%winesodir/wldap32.so
%libwinedir/%winesodir/mscms.so
%libwinedir/%winesodir/wmphoto.so
%libwinedir/%winesodir/msv1_0.so
%if_with opencl
%libwinedir/%winesodir/opencl.so
%endif
%libwinedir/%winesodir/secur32.so
%libwinedir/%winesodir/winepulse.so
%libwinedir/%winesodir/wpcap.so
%libwinedir/%winesodir/*.com.so
%libwinedir/%winesodir/*.cpl.so
%libwinedir/%winesodir/*.drv.so
%libwinedir/%winesodir/*.dll.so
%libwinedir/%winesodir/*.acm.so
%libwinedir/%winesodir/*.ocx.so
%libwinedir/%winesodir/*.tlb.so
%libwinedir/%winesodir/*.sys.so
%libwinedir/%winesodir/*.ax.so

%libwinedir/%winepedir/*.com
%libwinedir/%winepedir/*.cpl
%libwinedir/%winepedir/*.drv
%libwinedir/%winepedir/*.dll
%libwinedir/%winepedir/*.acm
%libwinedir/%winepedir/*.ocx
%libwinedir/%winepedir/*.tlb
%libwinedir/%winepedir/*.sys
%libwinedir/%winepedir/*.exe
%libwinedir/%winepedir/*.ax
%libwinedir/%winepedir/*.ds
%libwinedir/%winepedir/windows.networking.connectivity
%libwinedir/%winepedir/light.msstyles
%if_without build64
%libwinedir/%winepedir/*.dll16
%libwinedir/%winepedir/*.drv16
%libwinedir/%winepedir/*.exe16
%libwinedir/%winepedir/winoldap.mod16
%libwinedir/%winepedir/*.vxd
%endif

%dir %_datadir/wine/
%_datadir/wine/wine.inf
%_datadir/wine/nls/
%_datadir/wine/fonts/

# move to separate packages
%exclude %libwinedir/%winesodir/twain_32.dll.so
%exclude %libwinedir/%winepedir/twain_32.dll
%exclude %libwinedir/%winesodir/d3d10.dll.so
%exclude %libwinedir/%winesodir/d3d8.dll.so
%exclude %libwinedir/%winesodir/d3d9.dll.so
%exclude %libwinedir/%winesodir/d3dxof.dll.so
%exclude %libwinedir/%winesodir/opengl32.dll.so
%exclude %libwinedir/%winesodir/glu32.dll.so
%exclude %libwinedir/%winesodir/wined3d.dll.so
%exclude %libwinedir/%winesodir/winevulkan.so

%files full

%files programs
%_bindir/notepad
%_bindir/winefile
%_bindir/winemine
%_man1dir/notepad.*
%_man1dir/winefile.*
%_man1dir/winemine.*
%_desktopdir/wine-notepad.desktop
%_desktopdir/wine-winefile.desktop
%_desktopdir/wine-winemine.desktop


%files -n lib%name-twain
%libwinedir/%winepedir/twain_32.dll
%libwinedir/%winesodir/twain_32.dll.so
%libwinedir/%winesodir/gphoto2.ds.so
%libwinedir/%winesodir/sane.ds.so

%files -n lib%name-gl
%libwinedir/%winesodir/d3d10.dll.so
%libwinedir/%winesodir/d3d8.dll.so
%libwinedir/%winesodir/d3d9.dll.so
%libwinedir/%winesodir/d3dxof.dll.so
%libwinedir/%winesodir/opengl32.dll.so
%libwinedir/%winesodir/glu32.dll.so
%libwinedir/%winesodir/wined3d.dll.so
%libwinedir/%winesodir/winevulkan.so

%files -n lib%name-devel
%doc LICENSE
%_bindir/function_grep.pl
%_bindir/winebuild
%_bindir/wmc
%_bindir/wrc
%_bindir/widl
%_bindir/wineg++
%_bindir/winegcc
%_bindir/winecpp
%_bindir/winedump
%_bindir/winemaker
%_bindir/msidb

%_includedir/wine/
%libwinedir/%winesodir/lib*.def
%libwinedir/%winesodir/libwinecrt0.a
#%_aclocaldir/wine.m4

%_man1dir/wmc.*
%_man1dir/wrc.*
%_man1dir/widl.*
%_man1dir/winebuild.*
%_man1dir/winedump.*
%_man1dir/wineg++.*
%_man1dir/winegcc.*
%_man1dir/winecpp.*
%_man1dir/winemaker.*

%if_enabled static
%files -n lib%name-devel-static
%libwinedir/%winesodir/lib*.a
%exclude %libwinedir/%winesodir/libwinecrt0.a
%endif

%changelog
