Name: SDL_image
Version: 1.2.12
Release: alt2

Summary: Image loading library for SDL
Group: System/Libraries
License: LGPLv2+
Url: http://www.libsdl.org/projects/SDL_image/
# http://www.libsdl.org/projects/%name/release/%name-%version.tar.gz
Source: %name-%version.tar

%def_disable static
%define libname lib%name
# must match SDL_VERSION= in configure.ac
%define SDL_ver 1.2.10

BuildRequires: libSDL-devel >= %SDL_ver
BuildRequires: libjpeg-devel libpng-devel libtiff-devel zlib-devel

%description
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library
designed to provide fast access to the graphics frame buffer and audio
device.

%package -n %libname
Summary: %name runtime library
Group: System/Libraries

%description -n %libname
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library
designed to provide fast access to the graphics frame buffer and audio
device.  This package contains a simple library for loading images of
various formats (BMP, PPM, PCX, GIF, JPEG, PNG) as SDL surfaces.

%package -n %libname-devel
Summary: %name development files
Group: Development/C
Requires: %libname = %version-%release

%description -n %libname-devel
This package contains %name development library and header files
required to build %name-based software.

%package -n %libname-devel-static
Summary: Static libraries for developing programs that will use %name
Group: Development/C
Requires: %libname-devel = %version-%release

%description -n %libname-devel-static
This package contains %name static library required to build
statically-linked %name-based software.

%prep
%setup
# required for autoreconf
mv acinclude m4
rm m4/l*.m4
touch NEWS AUTHORS ChangeLog

%build
# required for properly linked showimage
%autoreconf
%configure \
	--enable-jpg \
	--enable-png \
	--enable-tif \
	--disable-jpg-shared \
	--disable-png-shared \
	--disable-tif-shared \
	%{subst_enable static}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_bindir
install -pm755 .libs/showimage %buildroot%_bindir/

%files -n %libname
%_bindir/showimage
%_libdir/*.so.*

%files -n %libname-devel
%_libdir/*.so
%_includedir/SDL/*
%_pkgconfigdir/*
%doc README CHANGES

%if_enabled static
%files -n %libname-devel-static
%_libdir/*.a
%endif

%changelog
