Name: acl
Version: 2.2.53
Release: alt1

Summary: ACL manipulation utilities
License: GPLv2+
Group: File tools
Url: http://savannah.nongnu.org/projects/acl
# git://git.altlinux.org/gears/a/acl.git
Source: %name-%version-%release.tar

Requires: lib%name = %version-%release
BuildRequires: libattr-devel
BuildConflicts: libacl-devel

%define _libexecdir %_libdir
%def_disable static

%description
This package contains chacl, getfacl, and setfacl utilities for
manipulating POSIX access control lists.

%package -n lib%name
Summary: Dynamic library for ACL support
License: LGPLv2+
Group: System/Libraries

%package -n lib%name-devel
Summary: ACL header files
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: ACL static library
License: LGPLv2+
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with lib%name.

%description -n lib%name-devel
This package contains header files needed to develop programs which
make use of POSIX access control lists.

%description -n lib%name-devel-static
This package contains the static library needed to develop statically
linked programs which make use of POSIX access control lists.

%prep
%setup

%build
./autogen.sh
%configure %{subst_enable static}
%make_build V=1

%install
%makeinstall_std \
	dist_doc_DATA='README doc/CHANGES doc/extensions.txt doc/libacl.txt'

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Relocate chacl.
mkdir %buildroot/bin
mv %buildroot%_bindir/chacl %buildroot/bin/

%find_lang %name
%set_verify_elf_method strict

%check
%make_build -k check

%files -f %name.lang
/bin/*
%_bindir/*
%_mandir/man[15]/*
%_docdir/%name/

%files -n lib%name
/%_lib/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_man3dir/*
%_includedir/acl/
%_includedir/sys/acl.h
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
