#Module-Specific definitions
%define mod_name mod_vdbh
%define mod_conf 21_%mod_name
%define mod_so %mod_name

Summary: A Virtual Database Hosting DSO module for the apache web server
Name: apache2-mod_vdbh
Version: 1.0.3
Release: alt2
Group: System/Servers
License: GPL
Url: http://www.synthemesc.com/mod_vdbh/
Packager: Boris Savelev <boris@altlinux.org>

Source: %mod_name-%version.tar.bz2
Source1: %mod_conf.conf
Source2: %mod_conf.load

# Automatically added by buildreq on Mon Feb 09 2009
BuildRequires: apache2-devel libMySQL-devel

%description
mod_vdbh is an Apache Web Server module allowing mass virtual
hosting without the need for file based configuration. The virtual
host paths are translated from a MySQL database at request time,
thus the configuration can be changed without having to restart
Apache Web Server.

%prep
%setup -q -n %mod_name-%version

# strip away annoying ^M
find . -type f|xargs file|grep 'CRLF'|cut -d: -f1|xargs perl -p -i -e 's/\r//'
find . -type f|xargs file|grep 'text'|cut -d: -f1|xargs perl -p -i -e 's/\r//'

%build
%apache2_apxs -DHAVE_STDDEF_H -I%_includedir/mysql -L%_libdir -Wl,-lmysqlclient -c mod_vdbh.c

%install
mkdir -p %buildroot%apache2_moduledir
mkdir -p %buildroot%apache2_mods_available
install -m 644 .libs/%mod_name.so %buildroot%apache2_moduledir/%mod_name.so
install -m 644 %SOURCE1 %buildroot%apache2_mods_available
install -m 644 %SOURCE2 %buildroot%apache2_mods_available

%files
%doc AUTHORS README TODO
%apache2_mods_available/*.load
%config %apache2_mods_available/*.conf
%apache2_moduledir/*.so

%changelog
