Name: astra
Version: 4.4
Release: alt8
Summary: Astra is a highly-customizable software for processing IPTV streams
Group: Networking/Other

Packager: Alexei Takaseev <taf@altlinux.ru>

License: GPLv3
Url: http://cesbo.com/astra
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: libssl-devel

%ifarch %ix86 x86_64
BuildRequires: libdvbcsa-devel
%endif

%description
Astra consists of the following components:

*   Core is an API to communicate with the operation system. Astra is a
    cross-platform software that supports:
    OS X, Linux (any distributives), BSD, Windows
*   Modules is a set of high-performance units that
    carries out specific functions
*   Lua is a scripting language to build a business logic for applications

%prep
%setup
%patch0 -p1

%build
./configure.sh \
%ifarch %ix86 x86_64
	--with-libdvbcsa \
%endif
	--bin=%_bindir/astra

%make_build

%install
install -m 0755 -D %name %buildroot%_bindir/%name
install -m 0755 -D scripts/analyze.lua %buildroot%_sysconfdir/%name/scripts/analyze.lua
install -m 0755 -D scripts/base.lua %buildroot%_sysconfdir/%name/scripts/base.lua
install -m 0755 -D scripts/dvbls.lua %buildroot%_sysconfdir/%name/scripts/dvbls.lua
install -m 0755 -D scripts/relay.lua %buildroot%_sysconfdir/%name/scripts/relay.lua
install -m 0755 -D scripts/stream.lua %buildroot%_sysconfdir/%name/scripts/stream.lua

%files
%doc COPYING README.md Astra.sublime-project scripts/examples/*
%_sysconfdir/%name/
%_bindir/*

%changelog
