%define realname automake
%define dialect _1.14
%define dialect_regex _1\\.14
%define suff -1.14
%define apiname %realname%suff

Name: %realname%dialect
Version: 1.14.1
Release: alt5

%define mydatadir %_datadir/%apiname
%set_compress_method xz
%define _perl_lib_path %perl_vendor_privlib:%mydatadir
%{?filter_from_requires:%filter_from_requires /^perl(\(Automake\|TAP\)/d}
%{?filter_from_provides:%filter_from_provides /^perl(/d}

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+ and GFDLv1.3+
Group: Development/Other
Url: https://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version-%release

# git://git.altlinux.org/gears/a/%name.git
Source: %srcname.tar

Requires: automake-common, autoconf >= 2:2.65

BuildPreReq: autoconf >= 2:2.65, gnu-config, help2man, makeinfo, perl-threads
BuildPreReq: perl(TAP/Parser.pm)
%{!?__buildreqs:%{!?_without_check:%{!?_disable_check:BuildRequires: dejagnu expect flex gcc-c++ gcc-fortran makedepend}}}

%description
Automake is a tool for automatically generating `Makefile.in'
files compliant with the GNU Coding Standards.

%prep
%setup -n %srcname
xz -k9 NEWS

# Patch texinfo file.
sed -i \
	-e '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1\2(%apiname)/' \
	-e '/^@\(setfilename\|settitle\)[[:space:]]\+%realname/ s//&%suff/' \
	doc/automake.texi

%build
%define docdir %_docdir/%realname-%version
./bootstrap.sh
%configure --docdir=%docdir --disable-silent-rules
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

# Provided by automake-common package.
rm %buildroot%_aclocaldir/README

# Provided by automake package.
rm %buildroot%_bindir/{aclocal,automake}
rm %buildroot%_man1dir/{aclocal,automake}.1*

# Provided by the latest automake.
rm %buildroot%_infodir/automake-history.info

# Replace config.* copies with symlinks to original files.
for f in %_datadir/gnu-config/config.*; do
	[ -f "$f" ] || continue
	ln -frs %buildroot"$f" %buildroot%mydatadir/"${f##*/}"
done

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

install -pm644 AUTHORS README THANKS NEWS.* \
	%buildroot%docdir/

# Reenable perl-threads dependencies.
%define __spec_autodep_custom_pre export AUTOMAKE_JOBS=1

%define _unpackaged_files_terminate_build 1
# This has no effect on this noarch package, but let it be.
%set_verify_elf_method strict

%check
%make_build -k check VERBOSE=1

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_bindir/*%suff
%_man1dir/*%suff.1*
%_datadir/aclocal%suff
%mydatadir/
%_infodir/*.info*
%docdir/

%changelog
