%define _pseudouser_user awstats
%define _pseudouser_group awstats
%define _pseudouser_home %_localstatedir/%name
%define	docdir %_docdir/%name-%version

Name: awstats
Version: 7.7
Release: alt0.6.20180105

Summary: Real-time logfile analyzer to get advanced web statistics
Summary(ru_RU.UTF8): Анализатор логов Web-сервера в режиме реального времени
License: GPL3
Group: Monitoring

Url: http://www.awstats.org
BuildArch: noarch

# https://github.com/eldy/awstats
Source: %name-%version.tar
Source1: awstats.cron
Source2: apache2.mods-start
Source3: apache2.sites-available
Source4: apache2.sites-start
Source5: apache2.ports-start
Source6: README.ALT.ru_RU.UTF8

Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-apache2

# Automatically added by buildreq on Wed Jul 21 2010 (-bi)
BuildRequires: apache2-common perl-libwww tzdata perl-Switch perl-CGI

%description
AWStats is a short for Advanced Web Statistics. It's a free tool that generates
advanced web (but also ftp, syslog or mail) server access statistics
graphically. This log analyzer works as a CGI or from command line and shows
you all possible information your log contains, in few graphical web pages. It
uses a partial information file to be able to process large log files, often
and quickly. It can analyze log files from IIS (W3C log format), Apache log
files (NCSA combined/XLF/ELF log format or common/CLF log format), WebStar and
most of all web, proxy, wap, streaming servers (and even syslog, ftp servers or
mail logs).

%description -l ru_RU.UTF8
AWStats это сокращение от Advanced Web Statistics (расширеная Веб-статистика).
Это бесплатный инструмент для генерации расширеной статистики графиков о работе
http (а так же ftp, syslog или mail) сервисов. Данный анализатор работает как
из командной строки так и в виде CGI-скрипта.

%package docs
Summary: AWStats documentation set
Group: Monitoring

%description docs
AWStats is a short for Advanced Web Statistics. It's a free tool that generates
advanced web (but also ftp, syslog or mail) server access statistics
graphically. This log analyzer works as a CGI or from command line and shows
you all possible information your log contains, in few graphical web pages. It
uses a partial information file to be able to process large log files, often
and quickly. It can analyze log files from IIS (W3C log format), Apache log
files (NCSA combined/XLF/ELF log format or common/CLF log format), WebStar and
most of all web, proxy, wap, streaming servers (and even syslog, ftp servers or
mail logs).

%package apache2
Summary: AWStats apache2-related config
Group: Monitoring 
Requires: %name = %version-%release
Requires: apache2-base

%description apache2
AWStats apache2-related config

%prep
%setup
%patch -p1
cp %SOURCE6 ./

%build
# build awgraphapplet.jar from source, avoiding upstream shipped binary
cd wwwroot/classes/src/
perl Makefile.pl

%install
install -d %buildroot%_datadir/%name
install -d %buildroot%_sysconfdir/{%name,cron.d}
install -d %buildroot%_pseudouser_home
install -d %buildroot%apache2_mods_start
install -d %buildroot%apache2_sites_available
install -d %buildroot%apache2_sites_start
install -d %buildroot%apache2_ports_start

cp -r {tools,wwwroot} %buildroot%_datadir/%name/
mv %buildroot%_datadir/%name/wwwroot/cgi-bin/{lang,lib,plugins} %buildroot%_datadir/%name/

# move unneeded files
mkdir examples
mv %buildroot%_datadir/%name/tools/{awstats_configure.pl,httpd_conf,webmin,xslt} examples/
mv %buildroot%_datadir/%name/wwwroot/cgi-bin/awredir.pl examples/
mv %buildroot%_datadir/%name/plugins/example/example.pm examples/

# fix permissions (again)
find %buildroot%_datadir/%name -name \*.pl -exec chmod 0755 {} \;

install -p -m644 %SOURCE1 %buildroot%_sysconfdir/cron.d/%name
install -p -m644 %SOURCE2 %buildroot%apache2_mods_start/%name.conf
install -p -m644 %SOURCE3 %buildroot%apache2_sites_available/%name.conf
install -p -m644 %SOURCE4 %buildroot%apache2_sites_start/%name.conf
install -p -m644 %SOURCE5 %buildroot%apache2_ports_start/%name.conf

%pre 
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'AWStats log analyzer' \
        -d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%pre apache2
/usr/sbin/usermod -g %_pseudouser_group -G %apache2_group %_pseudouser_user

%files
%_datadir/%name
%exclude %_datadir/%name/wwwroot/cgi-bin/awstats.model.conf
%exclude %_datadir/%name/wwwroot/classes/src
%exclude %_datadir/%name/plugins/example
# fix plugins perms
%attr(0644,root,root) %_datadir/%name/plugins/*.pm
%_sysconfdir/%name
%dir %attr(1775,root,%_pseudouser_group) %_pseudouser_home
%config(noreplace) %_sysconfdir/cron.d/%name
%doc README.md README.ALT.ru_RU.UTF8 wwwroot/cgi-bin/awstats.model.conf

%files docs
%doc docs examples

%files apache2
%config(noreplace) %apache2_mods_start/%name.conf
%config(noreplace) %apache2_sites_available/%name.conf
%config(noreplace) %apache2_sites_start/%name.conf
%config(noreplace) %apache2_ports_start/%name.conf

%changelog
