Name: bison
Version: 3.0.5
Release: alt1

Summary: A GNU general-purpose parser generator
License: GPLv3+
Group: Development/Other
Url: https://www.gnu.org/software/bison/

%define srcname %name-%version-%release
# git://git.altlinux.org/people/ldv/packages/bison refs/heads/master
Source0: %srcname.tar
# git://git.altlinux.org/people/ldv/packages/bison refs/heads/po-current
Source1: po-%version-%release.tar

Requires: m4 >= 0:1.4
Requires: %name-runtime = %version-%release
Provides: byacc = %version-%release
Obsoletes: byacc

BuildRequires: flex, gcc-c++, help2man, makeinfo
BuildRequires: gnulib >= 0.1.2305.95c96

%description
Bison is a general purpose parser generator which converts a grammar
description for an LALR(1) context-free grammar into a C program to
parse that grammar.  Bison can be used to develop a wide range of
language parsers, from ones used in simple desk calculators to complex
programming languages.  Bison is upwardly compatible with Yacc, so any
correctly written Yacc grammar should work with Bison without any
changes.  If you know Yacc, you shouldn't have any trouble using Bison.
You do need to be very proficient in C programming to be able to program
with Bison.  Many programs use Bison as part of their build process.
Bison is only needed on systems that are used for development.

%package runtime
Summary: Runtime support files used by Bison-generated parsers
Group: Development/C
BuildArch: noarch

%description runtime
This package contains files used at runtime by parsers that Bison
generates.  Packages whose binaries contain parsers generated by Bison
should depend on bison-runtime to ensure that these files are available.
See the Internationalization in the Bison manual section for more
information.

%prep
%setup -n %srcname -a1

# Build scripts expect to find the bison version in this file.
echo -n %version > .tarball-version

# Generate LINGUAS file.
ls po/*.po | sed 's|.*/||; s|\.po$||' > po/LINGUAS

# Install submodule files.
rm m4/m4.m4 data/m4sugar/{foreach,m4sugar}.m4 build-aux/move-if-change
ln -s %_aclocaldir/m3.m4 m4/
ln -s %_datadir/autoconf/m4sugar/{foreach,m4sugar}.m4 data/m4sugar/
ln -s %_datadir/gnulib/build-aux/move-if-change build-aux/

%build
./bootstrap --no-git --skip-po --gnulib-srcdir=%_datadir/gnulib
%configure --disable-silent-rules
touch src/scan-????.l
%make_build

%install
%makeinstall_std

%find_lang %name
%find_lang %name-runtime

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_libdir/lib*.a
%_datadir/bison/
%_datadir/aclocal/*
%_mandir/man?/*
%_infodir/*.info*
%doc %_docdir/%name/

%files -f %name-runtime.lang runtime

%changelog
