%def_disable snapshot

%define ver_major 0.23
%define beta %nil
%define efl_ver_major 1.22
%define efl_ver %efl_ver_major.3

%def_enable bluetooth
%def_enable wayland
%def_enable xwayland
%def_enable wl_drm
%def_enable wl_x11
%def_enable systemd
%def_enable connman
%def_enable packagekit
%def_enable install_sysactions
%def_with suid_binaries
# for silly lightdm
%def_disable wmsession

Name: enlightenment
Version: %ver_major.1
Release: alt1
Epoch: 1

Summary: The Enlightenment window manager
License: BSD
Group: Graphical desktop/Enlightenment
URL: http://www.enlightenment.org/

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: https://download.enlightenment.org/rel/apps/%name/%name-%version%beta.tar.xz
%endif

Source1: E.png
Source2: start_%name
Source3: %name.wmsession
Source8: %name.desktop
%{?_enable_install_sysactions:Source11: %name-alt-sysactions.conf}

# revert it for patch enlightenment-0.19.0-alt-pam-helper.patch
Patch: enlightenment-0.22.2-up-auth.patch
Patch1: e17-0.17.0-alt-g-s-d_path.patch
Patch2: enlightenment-0.22.4-alt-e_sys_nosuid.patch
Patch3: auto-ptrace-disable.patch
Patch4: enlightenment-0.19.0-alt-pam-helper.patch

Provides: e19 = %EVR
# Obsoletes/Provides old eNN
Obsoletes: e17 e18
Provides: e17 = %EVR
Provides: e18 = %EVR
Provides: %name-default
Obsoletes: e17-default e18-default
Provides: e17-default = %EVR
Provides: e18-default = %EVR

# default terminal
Requires: terminology
# default image viewer
Requires: ephoto
# default media player
Requires: rage
# for menu
Requires: gnome-icon-theme
Requires: wm-common-freedesktop
Requires: altlinux-freedesktop-menu-%name >= 0.55
Requires: udisks2
Requires: pulseaudio-daemon
Requires: geoclue2
Requires: connman
# for the evrything module calculator mode
Requires: bc
%{?_enable_xwayland:Requires: xorg-xwayland xorg-drv-libinput}
%{?_enable_bluetooth:Requires: bluez %_sbindir/rfkill}
%{?_enable_connman:Requires: connman}
%{?_enable_packagekit:Requires: packagekit}

BuildRequires(pre): meson rpm-build-xdg
BuildRequires: efl-libs-devel >= %efl_ver libelementary-devel >= %efl_ver
BuildRequires: libpam-devel libalsa-devel libudev-devel libxcbutil-keysyms-devel
BuildRequires: libdbus-devel libp11-kit-devel xorg-xproto-devel libxcbutil-keysyms-devel
BuildRequires: libuuid-devel libpulseaudio-devel
BuildRequires: xkeyboard-config-devel libxkbcommon-devel libdrm-devel libgbm-devel
BuildRequires: doxygen
# for sysv
BuildRequires: pm-utils
%{?_enable_bluetooth:BuildRequires: libbluez-devel %_bindir/l2ping %_sbindir/rfkill}
%{?_enable_wayland:BuildRequires: libwayland-server-devel >= 1.3.0 libpixman-devel libEGL-devel libwayland-egl-devel wayland-protocols}
%{?_enable_xwayland:BuildRequires: xorg-xwayland}
%{?_enable_systemd:BuildRequires: systemd-devel}

%description
Enlightenment is a window manager.

%package devel
Summary: Development headers for Enlightenment.
Group: Development/C
Requires: %name = %EVR
# Obsoletes/Provides old eNN
Obsoletes: e17-devel e18-devel
Provides: e17-devel = %EVR
Provides: e18-devel = %EVR

%description devel
Development headers for Enlightenment.

%prep
%setup -n %name-%version
#%patch -p1 -R -b .auth
%patch1 -p1 -b .gsd
%{?_without_suid_binaries:%patch2 -p1 -b .nosuid}
%patch3 -p2 -b .ptrace

# fix logic
sed -i "s/\(if config_h\.has('HAVE_WAYLAND') == \)false/\1true/" data/session/meson.build

%build
%meson \
	-Dfiles=true \
	-Dpam=true \
	%{?_enable_wayland:-Dwl=true} \
	%{?_enable_xwayland:-Dxwayland=true -Dxwayland-bin=%_bindir/Xwayland} \
	%{?_disable_wl_drm:-Dwl-drm=false} \
	%{?_disable_wl_x11:-Dwl-x11=false} \
	%{?_disable_install_sysactions:-Dinstall-sysactions=flase} \
	%{?_disable_connman:-Dconnman=false} \
	%{?_disable_packagekit:-Dpackagekit=false} \
	%nil
%meson_build

%install
%meson_install

mkdir -p %buildroot%_rpmmacrosdir
cat > %buildroot%_rpmmacrosdir/%name <<_EOF_
%%enlightenment_version		%version
_EOF_

# Install icon
install -pD -m644 %SOURCE1 %buildroot%_liconsdir/E-18.png

# PAM-config
mkdir -p %buildroot%_sysconfdir/pam.d
cat > %buildroot%_sysconfdir/pam.d/%name << _PAM_
#%%PAM-1.0

auth		include		system-auth
account		required	pam_deny.so
password	required	pam_deny.so
session		required	pam_deny.so
_PAM_

# replace original sysaction.conf
cp %SOURCE11 %buildroot%_sysconfdir/%name/sysactions.conf

# replace original menus by symlink to our enlightenment.menu
ln -sf %name.menu %buildroot/%_xdgmenusdir/e-applications.menu

%if_enabled wmsession
mkdir -p %buildroot%_bindir/
mkdir -p %buildroot%_sysconfdir/X11/wmsession.d
install -D -pm 644 %SOURCE3 %buildroot%_sysconfdir/X11/wmsession.d/05Enlightenment
# replace original desktop file
install -pD -m 644 %SOURCE8 %buildroot%_desktopdir/%name.desktop
%endif

# fix Name in session desktop files
sed -i 's/^\(Name.*=Enlightenment\)$/\1 on Xorg/' %buildroot%_datadir/xsessions/%name.desktop
sed -i 's/^\(Name.*=Enlightenment\)$/\1 on Wayland/' %buildroot%_datadir/wayland-sessions/%name.desktop
# rename xsession file
mv %buildroot%_datadir/xsessions/%name.desktop %buildroot%_datadir/xsessions/%name-xorg.desktop

# use start_enlighttenment instead of enlightenment_start for lightdm
install -p -m755 %SOURCE2 %buildroot%_bindir/
sed -i 's/\(enlightenment\)_start/start_\1/' %buildroot%_datadir/xsessions/%name-xorg.desktop

%find_lang %name

%files -f %name.lang

%{?_enable_wmsession:%config %_sysconfdir/X11/wmsession.d/*}
%config %_sysconfdir/%name/sysactions.conf
%config(noreplace) %_sysconfdir/pam.d/%name
%dir %_libdir/%name/
%_libdir/%name/modules/
%{?_enable_wayland:%_libdir/%name/gadgets/}
%dir %_libdir/%name/utils
%_libdir/%name/utils/%{name}_alert
%_libdir/%name/utils/%{name}_elm_cfgtool
%_libdir/%name/utils/%{name}_fm
%_libdir/%name/utils/%{name}_fm_op
%_libdir/%name/utils/%{name}_static_grabber
%_libdir/%name/utils/%{name}_thumb
# suid bit apps
%_libdir/%name/utils/%{name}_backlight
%_libdir/%name/utils/%{name}_sys
%_libdir/%name/utils/%{name}_ckpasswd
%_liconsdir/*.png
%_bindir/emixer
%_bindir/%name
%_bindir/%{name}_askpass
%_bindir/%{name}_filemanager
%_bindir/%{name}_imc
%_bindir/%{name}_open
%_bindir/%{name}_remote
%_bindir/%{name}_start
%_bindir/start_%name
%_datadir/%name/
%_datadir/xsessions/%name-xorg.desktop
%{?_enable_wayland:%_datadir/wayland-sessions/%name.desktop}
%_datadir/pixmaps/emixer.png
%_pixmapsdir/%name-askpass.png
%_desktopdir/*.desktop
%{?_enable_systemd:%_prefix/lib/systemd/user/%name.service}
%_xdgmenusdir/e-applications.menu
%doc AUTHORS COPYING README

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_pkgconfigdir/everything.pc
%_rpmmacrosdir/%name

%changelog
