Name: firmware-linux
Version: 20210518
Release: alt1

Summary: Firmware files used by the Linux kernel
License: GPL+ and GPLv2+ and MIT and Redistributable, no modification permitted
Group: System/Kernel and hardware

Url: git://git.kernel.org/pub/scm/linux/kernel/git/firmware/linux-firmware.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch
Provides: linux-firmware
Provides: firmware-iwl1000
Provides: firmware-iwl3945 firmware-iwl4965 firmware-iwl5000 firmware-iwl5150
Provides: firmware-iwl6000 firmware-iwl6050
Obsoletes: firmware-iwl1000
Obsoletes: firmware-iwl3945 firmware-iwl4965 firmware-iwl5000 firmware-iwl5150
Obsoletes: firmware-iwl6000 firmware-iwl6050
Provides:  firmware-carl9170-1.9.4 firmware-i2400m firmware-rt2870 firmware-rt3090
Obsoletes: firmware-carl9170-1.9.4 firmware-i2400m firmware-rt2870 firmware-rt3090
Provides: firmware-rt61pci firmware-rt73usb
Obsoletes: firmware-rt61pci firmware-rt73usb
Obsoletes: firmware-libertas-sd8686 firmware-libertas-usb8388
Provides: firmware-ql2100 firmware-ql2200 firmware-ql2300 firmware-ql2322 firmware-ql2400 firmware-ql2500
Obsoletes: firmware-ql2100 firmware-ql2200 firmware-ql2300 firmware-ql2322 firmware-ql2400 firmware-ql2500
Provides: firmware-amd-ucode
Obsoletes: firmware-amd-ucode <= 2.0

BuildRequires: hardlink
Requires: udev
AutoReqProv: no

%add_verify_elf_skiplist /lib/firmware/*

%description
Kernel-firmware includes firmware files
required for some devices to operate.

%package netronome
Group: System/Kernel and hardware
Summary: firmware for Agilio SmartNICs

%description netronome
firmware for Agilio SmartNICs

%package liquidio
Group: System/Kernel and hardware
Summary: firmware for LiquidIO Smart NICs

%description liquidio
firmware for LiquidIO II Smart NICs

%prep
%setup -n %name-%version
%patch -p1

%install
DESTDIR=%buildroot FIRMWAREDIR=lib/firmware make install
hardlink -cv %buildroot/lib/firmware

## *TODO* check these too
rm -rf %buildroot/lib/firmware{ess,korg,sb16,yamaha}

%files
%doc WHENCE LICEN?E.*
/lib/firmware/*
%exclude /lib/firmware/netronome
%exclude /lib/firmware/liquidio

%files netronome
/lib/firmware/netronome

%files liquidio
/lib/firmware/liquidio

%changelog
