%define _name flare

Name: %_name-game
Version: 1.12
Release: alt1

Summary: Fantasy action RPG using the FLARE engine
# All of Flare's art and data files are released under CC-BY-SA 3.0.
# Later versions are permitted.
# The Liberation Sans fonts version 2 are released under the SIL Open
# Font License, Version 1.1.
License: CC-BY-SA-3.0 and OFL-1.1
Group: Games/Adventure

URL: http://flarerpg.org/
Vcs: https://github.com/flareteam/flare-game.git
Source: %name-%version.tar
#Patch: %name-%version-%release.patch
BuildArch: noarch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake

Requires: %_name-engine >= %version

Obsoletes: flare < %version-%release
Provides: flare = %version-%release
Obsoletes: flare-data < %version-%release
Provides: flare-data = %version-%release

%define _unpackaged_files_terminate_build 1

%description
The Empyrean Campaign is a single-player 2D action RPG with fast-paced action
and a dark fantasy style.
It is built on the FLARE engine (Free/Libre Action Roleplaying Engine).

%prep
%setup
#patch -p1

%build
%cmake -DBINDIR=bin -DDATADIR=share/flare
%cmake_build

%install
%cmake_install
%find_lang %_name

%files -f %_name.lang
%_datadir/%_name/*
%_datadir/metainfo/*.xml

%changelog
