%define foomatic_version 4.0.3
%define snapshot 20190317

%def_disable foo2zjs

Name: foomatic-db
Version: 4.0.%snapshot
Release: alt1

Summary: Foomatic printer database
License: GPL
Group: Publishing

BuildArch: noarch

Url: http://www.openprinting.org

# it is no more true for 4.x
# foomatic-db included foomatic-db-hpijs (exept for hpijs junk in db/source)
#Provides: foomatic-db-hpijs = %version-%release
#Provides: hplip-foomatic = 2.8.0
#Obsoletes: hplip-foomatic < 2.8.0

# http://www.openprinting.org/download/foomatic/
Source0: http://www.openprinting.org/download/foomatic/%name-%version.tar

# sync with SuSE cups-drivers-1.3.9-2.10.src.rpm
# note: cups-drivers-1.3.8-A4.patch is hacked manually for 4.0
#Patch0: cups-drivers-1.1.23-stcolor.patch
Patch0: foomatic-db-20100623-cups-drivers-stcolor.patch
#Patch1: cups-drivers-1.3.8-A4.patch
Patch1: cups-drivers-1.3.8-A4-alt.patch
Patch2: cups-drivers-1.3.8-hl7x0_language-alt.patch
Patch5: cups-drivers-1.3.8-samsunggdi-alt.patch

PreReq: foomatic-db-engine >= %foomatic_version

#we need foomatic-kitload during install
BuildPreReq: foomatic-db-engine cups >= 1.2.1

# Automatically added by buildreq on Fri May 26 2006 (-bi)
BuildRequires: cups foomatic-db-engine 
# autoremove conflicts
BuildRequires: foomatic-db-foo2zjs

%description
This package is the Foomatic database, an XML database containing
information about the capabilities of near 1000 printers and around
250 drivers. Especially it contains the information how and with which
options the drivers have to be executed.

The site http://www.linuxprinting.org/ is based in this database.

%if_enabled foo2zjs
%package -n foomatic-db-foo2zjs
BuildArch: noarch
Summary: Database of printers supported by foo2zjs drivers
Summary(ru_RU.UTF8): База данных принтеров, которые поддерживаются драйверами foo2zjs.
Group: System/Configuration/Hardware
#Requires: %name = %version-%release

%description -n foomatic-db-foo2zjs
Database of printers that are supported by foo2zjs drivers.

%description -l ru_RU.UTF-8 -n foomatic-db-foo2zjs
База данных принтеров, которые поддерживаются драйверами foo2zjs.
%endif

%package -n foomatic-db-docs
BuildArch: noarch
Summary: documentation files for the Foomatic printer database.
Summary(ru_RU.UTF8): Документация к базе данных принтеров Foomatic. 
Group: Documentation

%description -n foomatic-db-docs
This package is the documentation files for the Foomatic database.
It contains README and ChangeLog.

%description -l ru_RU.UTF-8 -n foomatic-db-docs
Документация к базе данных принтеров Foomatic. 
Включает в себя README и ChangeLog.

%prep
%setup -q
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch5 -p2

xz ChangeLog

%build
./make_configure
%configure --disable-gzip-ppds


# Delete drivers with empty command line prototype, they would give
# unusable printer/driver combos.
FOOMATICDB=`pwd` %_sbindir/foomatic-cleanupdrivers

%install
# Install data files
make	PREFIX=%_prefix \
        DESTDIR=%buildroot \
        install

# alt bug #26381
find %buildroot/usr/share/cups/model/ -name '*.htm' -print -delete
find %buildroot/usr/share/foomatic/db/ -name '*.htm' -print -delete

##force A4
#find %buildroot/%_datadir/%name/model -name "*.ppd" -print0 |
#	xargs -r0 perl -pi -e 's:^(\*Default.*)Letter\s*$:$1A4\n:; \
#		s:^(\*ImageableArea A4.*\:\s+)"0 0 595 842":$1"24 48 571 818":; \
#		s:^(\*ImageableArea Letter.*\:\s+)"0 0 612 792":$1"24 48 588 768":; \
#		s:\s\n:\n:'

#force A4
find %buildroot/%_datadir/%name/source/PPD -type f -name "*.ppd" -print0 |
	xargs -r0 perl -pi -e 's:^(\*Default.*)Letter\s*$:$1A4\n:; \
		s:\s\n:\n:'

# remove file conflicts with foomatic-db-foo2zjs
for i in `rpm -ql foomatic-db-foo2zjs| grep /usr/share/foomatic/db/source/printer/`; do
	rm -f %buildroot$i
done
# just in case
grep -rl 'foo2' %buildroot/usr/share/foomatic/db/source/printer | sed -e 's,%buildroot,,' | sort -u > foomatic-db-foo2zjs.ls
find %buildroot/usr/share/foomatic/db/source/printer -type f | sed -e 's,%buildroot,,' | sort > foomatic-db-all.ls
comm -23 foomatic-db-all.ls foomatic-db-foo2zjs.ls > foomatic-db-main.ls


%files -f foomatic-db-main.ls
%doc USAGE
%dir %_datadir/foomatic
%dir %_datadir/foomatic/db
%dir %_datadir/foomatic/db/source
%dir %_datadir/foomatic/db/source/printer
%_datadir/foomatic/db/oldprinterids
%_datadir/foomatic/db/source/PPD
%_datadir/foomatic/db/source/driver
%_datadir/foomatic/db/source/opt
%_datadir/foomatic/xmlschema

# killed by foomatic-cleanupdrivers
#%exclude %_datadir/foomatic/db/source/driver/foo2*

%_datadir/cups/model/foomatic-db-ppds

#not found in tarball
#%exclude %_datadir/foomatic/db/source/PPD/*.sh

%if_enabled foo2zjs
%files -n foomatic-db-foo2zjs -f foomatic-db-foo2zjs.ls
# killed by foomatic-cleanupdrivers
#%_datadir/foomatic/db/source/driver/foo2*
%endif

%files -n foomatic-db-docs
%doc README ChangeLog.xz

%changelog
