Name: geany-plugins
Version: 1.35
Release: alt1
%define geany_ver %version

Summary: Plugins for Geany

License: GPLv2
Group: Development/Tools
Url: http://plugins.geany.org/

Source: %name-%version.tar.bz2

BuildRequires(pre): geany geany-devel intltool
# Hack out self-providing symbols
%add_python_req_skip app
%add_python_req_skip dialogs
%add_python_req_skip document
%add_python_req_skip encoding
%add_python_req_skip filetypes
%add_python_req_skip glog
%add_python_req_skip highlighting
%add_python_req_skip keybindings
%add_python_req_skip main
%add_python_req_skip msgwindow
%add_python_req_skip navqueue
%add_python_req_skip prefs
%add_python_req_skip project
%add_python_req_skip scintilla
%add_python_req_skip search
%add_python_req_skip ui_utils
%add_python_req_skip templates

Requires: geany-plugins-vc

# Automatically added by buildreq on Wed Feb 27 2019
# optimized out: fontconfig fontconfig-devel geany glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libXext-devel libatk-devel libcairo-devel libcrypt-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libgpg-error-devel libgtk+2-devel libjavascriptcoregtk2-devel liblua5.1-devel libpango-devel libsoup-devel perl perl-XML-Parser pkg-config python-base python-devel python-module-docutils python-module-pygobject-devel python-modules python-modules-distutils sh4 vala xorg-proto-devel zlib-devel
BuildRequires: cppcheck geany-devel intltool libGConf-devel libcheck-devel libenchant-devel libgit2-devel libgpgme-devel libgtkspell-devel libvte-devel libwebkitgtk2-devel libwnck-devel libxml2-devel python-module-pygtk-devel libctpl-devel

BuildRequires: liblua5.1-devel

%description
This is Geany plugin collection

%package common
Group: Development/Tools
Requires: geany = %geany_ver
Summary: Localization and other platform independent stuff of geany-plugins
BuildArch: noarch

%description common
Common files of geany-plugins, including localization

%package vc
Group: Development/Tools
Requires: geany-plugins-common = %version-%release
Summary: Geany VC integration plugin

%description vc
Various VCS integration (Git, SVN, ...) for Geany

%prep
%setup
sed -i '/^geanyluadir/s@.*@geanyluadir = %_libdir/geany@' geanylua/Makefile.am

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std --silent --no-print-directory
%find_lang %name

%files
%doc %_defaultdocdir/%name
%_libdir/geany/*
%_libdir/lib*
%_datadir/geany-plugins/*
#dir #_libexecdir/geany-plugins
#_libexecdir/geany-plugins/*
#_iconsdir/hicolor/*/apps/*
%exclude %_libdir/geany/geanyvc*
%exclude %_libdir/geany/*.la
#exclude %_libdir/geany-plugins/*/*.la

%files common -f %name.lang
%files vc
%_libdir/geany/geanyvc*
%exclude %_libdir/geany/*.la

%changelog
