%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.34
%define xdg_name org.gnome.Geary
# Elementary OS-specific
%def_disable contractor
%def_enable valadoc
%def_enable libunwind

Name: geary
Version: %ver_major.2
Release: alt0.M90P.1

Summary: Email client
License: LGPLv2.1+
Group: Networking/Mail
Url: https://wiki.gnome.org/Apps/Geary

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define vala_ver 0.26
%define gtk_ver 3.24.7
%define sqlite_ver 3.12.0
%define gcr_ver 3.10.1
%define webkit_ver 2.20

Requires: dconf gnome-keyring gcr

BuildRequires(pre): meson
BuildRequires: vala-tools >= %vala_ver libvala-devel
BuildRequires: desktop-file-utils yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: iso-codes-devel libgmime-devel
BuildRequires: libnotify-devel libcanberra-devel libgee0.8-devel
BuildRequires: libsoup-devel libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libgnome-online-accounts-devel libjson-glib-devel
BuildRequires: libenchant-devel libsecret-devel libxml2-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libsoup-gir-devel libwebkit2gtk-gir-devel libcanberra-vala
BuildRequires: gcr-libs-devel >= %gcr_ver gcr-libs-vala
BuildRequires: libfolks-devel  libfolks-vala libenchant2-devel
BuildRequires: libytnef-devel libdbus-devel libgspell-devel libhandy-devel
%{?_enable_libunwind:BuildRequires: libunwind-devel}
%{?_enable_valadoc:BuildRequires: valadoc}

%description
Geary is an email client built for the GNOME desktop environment.  It
allows you to read and send email with a simple, modern interface.

Visit http://www.yorba.org to read about the current state of.
Geary's development.

%prep
%setup

%build
%add_optflags -I%_includedir/libytnef
%meson %{?_enable_contractor:-Dcontractor=true} \
	%{?_disable_libunwind:-Dlibunwind_optional=true}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%{?_enable_contractor:%_bindir/%name-attach}
%_libdir/%name/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%name-autostart.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/*/*/apps/*
%_iconsdir/hicolor/scalable/actions/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_contractor:%_datadir/contractor/geary-attach.contract}
%doc AUTHORS NEWS README THANKS

%changelog
