%define        pkgname        puppet
%define        confdir        ext/redhat

Name:          gem-%pkgname
Version:       7.0.0
Release:       alt1
Summary:       A network tool for managing many disparate systems
Group:         Development/Ruby
License:       Apache-2.0
Url:           https://puppet.com/
Vcs:           https://github.com/puppetlabs/puppet.git
BuildArch:     noarch

Source:        %name-%version.tar
Source1:       client.init
Source2:       puppet.service
Source3:       puppet-nm-dispatcher

Patch1: puppet-alt-adjust-default-paths.patch
Patch2: puppet-fix-locale-loading.patch
Patch3: puppet-alt-aptrpm-osfamily.patch

BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(yard)

%gem_replace_version CFPropertyList ~> 3.0
%add_findreq_skiplist %ruby_gemslibdir/*
%add_findprov_skiplist %ruby_gemslibdir/**/*

%description
Puppet lets you centrally manage every important aspect of your
system using a cross-platform specification language that manages
all the separate elements normally aggregated in different files,
like users, cron jobs, and hosts, along with obviously discrete
elements like packages, services, and files.


%package       -n %pkgname
Summary:       Executable for a network tool for managing many disparate systems
Group:         System/Servers
BuildArch:     noarch

Requires:      shadow-change

%description   -n %pkgname
%summary.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%ruby_build --ignore=full_catalog,acceptance

%install
%ruby_install

# SysVInit files
install -Dp -m0644 %confdir/client.sysconfig %buildroot%_sysconfdir/sysconfig/puppet
install -Dp -m0755 %SOURCE1 %buildroot%_initrddir/puppet
# Systemd files
install -Dp -m0644 %SOURCE2 %buildroot%_unitdir/puppet.service
ln -s %_unitdir/puppet.service %buildroot%_unitdir/puppetagent.service

install -Dp -m0644 %confdir/logrotate %buildroot%_sysconfdir/logrotate.d/puppet
install -Dp -m0644 conf/fileserver.conf %buildroot%_sysconfdir/puppet/fileserver.conf

# Create other configuration directories
mkdir -p %buildroot%_sysconfdir/puppet/ssl/{public_keys,certificate_requests,certs,ca/requests,ca/private,ca/signed,private,private_keys}
mkdir -p %buildroot%_sysconfdir/puppet/code/environments/production/manifests

# Setup tmpfiles.d config
mkdir -p %buildroot%_tmpfilesdir
echo "D /run/%pkgname 0755 _%pkgname %pkgname -" > \
    %buildroot%_tmpfilesdir/%pkgname.conf

# Create puppet modules directory for puppet module tool
mkdir -p %buildroot%_sysconfdir/%pkgname/code/modules
touch %buildroot%_sysconfdir/puppet/code/modules/.dir

# Create service directory
mkdir -p %buildroot{%_cachedir,%_logdir,/run}/puppet

# Install NetworkManager dispatcher
install -Dpv %SOURCE3 \
    %buildroot%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}

# Add puppetdb example configuration to puppet.conf
cat >> %buildroot%_sysconfdir/puppet/puppet.conf << END.
# Example of puppetdb integration
#[master]
#storeconfigs = true
#storeconfigs_backend = puppetdb
#report = true
#reports = puppetdb
#
#[agent]
#server = puppet
END.

# link to gem library code base
ln -s %ruby_gemlibdir %buildroot%_datadir/%pkgname

# Create public subdirectory
mkdir -p %buildroot%ruby_gemlibdir/public
touch %buildroot%ruby_gemlibdir/public/.dir

# Create locale and modules directories
mkdir -p %buildroot%_datadir/puppet-{locale,modules}
touch %buildroot%_datadir/puppet-{locale,modules}/.dir

%pre           -n %pkgname
[ ! -d %_sysconfdir/puppetlabs/puppet/ssl ] || (
   cp -rf %_sysconfdir/puppetlabs/puppet/ssl %_sysconfdir/puppet &&
   rm -rf %_sysconfdir/puppetlabs/puppet/ssl)
getent group foreman >/dev/null || %_sbindir/groupadd -r foreman
getent group puppet >/dev/null || %_sbindir/groupadd -r puppet
%_sbindir/useradd -r -n -G puppet,foreman -d %_cachedir/puppet -s /dev/null -c Puppet _puppet >/dev/null 2>&1 ||:

%post          -n %pkgname
%post_service puppet

%preun         -n %pkgname
%preun_service puppet

%files
%ruby_gemspec
%ruby_gemlibdir

%files         -n %pkgname
%_bindir/puppet
%_initdir/puppet
%_unitdir/puppet.service
%_unitdir/puppetagent.service
%config(noreplace) %_tmpfilesdir/%pkgname.conf
%dir %_sysconfdir/puppet
%attr(0771,_puppet,puppet) %dir %_sysconfdir/puppet/ssl
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/public_keys
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certificate_requests
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certs
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/requests
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/private
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/signed
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private_keys
%dir %_sysconfdir/puppet/code/environments
%dir %_sysconfdir/puppet/code/environments/production
%dir %_sysconfdir/puppet/code/environments/production/manifests
%dir %_sysconfdir/puppet/code
%_sysconfdir/puppet/code
%config(noreplace) %_sysconfdir/puppet/puppet.conf
%config(noreplace) %_sysconfdir/sysconfig/puppet
%config(noreplace) %_sysconfdir/logrotate.d/puppet
%config(noreplace) %_sysconfdir/puppet/fileserver.conf
%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}
%_datadir/puppet
%_datadir/puppet-locale
%_datadir/puppet-modules
%attr(1770,_puppet,puppet) %dir %_cachedir/puppet
%_cachedir/puppet/
%attr(1770,_puppet,puppet) %dir %_logdir/puppet
%attr(1770,_puppet,puppet) %dir /run/puppet
%doc %_man8dir/*
%doc %_man5dir/puppet.conf.5*


%files         doc
%ruby_gemdocdir

%changelog
